/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestRedirectURILookupFunction
extends AbstractAuthenticationRequestLookupFunction<URI> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestRedirectURILookupFunction.class);

    @Override
    protected URI doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("redirect_uri") != null) {
                Object redirect = this.getRequestObject().getJWTClaimsSet().getClaim("redirect_uri");
                if (redirect instanceof String) {
                    return new URI((String)redirect);
                }
                this.log.error("login_hint claim is not of expected type");
                return null;
            }
        }
        catch (URISyntaxException | ParseException e) {
            this.log.error("Unable to parse login hint from request object login_hint value");
            return null;
        }
        return req.getRedirectionURI();
    }
}

