/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestMaxAgeLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Duration> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestMaxAgeLookupFunction.class);

    @Override
    protected Duration doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("max_age") != null) {
                return Duration.ofSeconds(this.getRequestObject().getJWTClaimsSet().getIntegerClaim("max_age").intValue());
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse state from request object state value");
            return null;
        }
        return req.getMaxAge() == -1 ? null : Duration.ofSeconds(req.getMaxAge());
    }
}

