/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestCodeChallengeMethodLookupFunction
extends AbstractAuthenticationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestCodeChallengeMethodLookupFunction.class);

    @Override
    protected String doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("code_challenge_method") != null) {
                Object codeChallenge = this.getRequestObject().getJWTClaimsSet().getClaim("code_challenge_method");
                if (codeChallenge instanceof String) {
                    return (String)codeChallenge;
                }
                this.log.error("code_challenge_method claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse code challenge method  from request object code_challenge_method value");
            return null;
        }
        return req.getCodeChallengeMethod() == null ? null : req.getCodeChallengeMethod().getValue();
    }
}

