/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestAudienceLookupFunction
extends AbstractAuthenticationRequestLookupFunction<List<String>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestAudienceLookupFunction.class);

    @Override
    @Nullable
    protected List<String> doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("resource") != null) {
                Object resource = this.getRequestObject().getJWTClaimsSet().getClaim("resource");
                if (resource instanceof String) {
                    return Collections.singletonList((String)resource);
                }
                if (resource instanceof List) {
                    return (List)resource;
                }
                if (resource != null) {
                    this.log.error("resource claim is not of expected type");
                    return null;
                }
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse request object");
            return null;
        }
        return req.getResources() == null ? null : req.getResources().stream().map(URI::toString).collect(Collectors.toUnmodifiableList());
    }
}

