/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyRequestedSubjectIdentifier
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(VerifyRequestedSubjectIdentifier.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String requestedSubject = this.getOidcResponseContext().getRequestedSubject();
        String generatedSubject = this.getOidcResponseContext().getSubject();
        if (requestedSubject == null) {
            this.log.debug("{} No requested subject, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (!requestedSubject.equals(generatedSubject)) {
            this.log.error("{} client requested for subject {}, the produced subject is {}, mismatch", new Object[]{this.getLogPrefix(), requestedSubject, generatedSubject});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return;
        }
        this.log.debug("{} Requested subject matched the generated subject {}", (Object)this.getLogPrefix(), (Object)generatedSubject);
    }
}

