/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.navigate.AlwaysIncludedAttributesLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.DeniedUserInfoAttributesLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.EncodedAttributesLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTokenDeliveryAttributesToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetTokenDeliveryAttributesToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> encodedAttributesLookupStrategy = new EncodedAttributesLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> alwaysIncludedAttributesLookupStrategy = new AlwaysIncludedAttributesLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy = new DeniedUserInfoAttributesLookupFunction();
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    private boolean ignoringUnencodableAttributes = true;
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    @NonnullElements
    private Set<String> encodedAttributes;
    @Nullable
    @NonnullElements
    private Set<String> alwaysIncludedAttributes;
    @Nullable
    @NonnullElements
    private Set<String> deniedUserInfoAttributes;

    SetTokenDeliveryAttributesToResponseContext() {
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoringUnencodableAttributes = flag;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setEncodedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encodedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Encoded attributes lookup strategy cannot be null");
    }

    public void setAlwaysIncludedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.alwaysIncludedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Always included ID token attributes lookup strategy cannot be null");
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Denied UserInfo attributes lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.encodedAttributes = this.encodedAttributesLookupStrategy.apply(profileRequestContext);
        if (this.encodedAttributes == null) {
            this.encodedAttributes = Collections.emptySet();
        }
        this.alwaysIncludedAttributes = this.alwaysIncludedAttributesLookupStrategy.apply(profileRequestContext);
        if (this.alwaysIncludedAttributes == null) {
            this.alwaysIncludedAttributes = Collections.emptySet();
        }
        this.deniedUserInfoAttributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (this.deniedUserInfoAttributes == null) {
            this.deniedUserInfoAttributes = Collections.emptySet();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transoding service unavailable");
                throw new AttributeEncodingException("Attribute transoding service unavailable");
            }
            for (IdPAttribute attribute : this.attributeCtx.getIdPAttributes().values()) {
                if (attribute == null || attribute.getValues().isEmpty() || !this.encodedAttributes.contains(attribute.getId())) continue;
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute);
            }
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
            return;
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        Collection transcodingRules = registry.getTranscodingRules(attribute, JSONObject.class);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return;
        }
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class, true);
        AttributesMapContainer requestedToIdTokenContainer = this.getOidcResponseContext().getMappedIdTokenRequestedClaims();
        for (TranscodingRule rule : transcodingRules) {
            try {
                JSONObject encodedAttribute;
                boolean requestedToIdToken;
                AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
                boolean bl = requestedToIdToken = requestedToIdTokenContainer != null && requestedToIdTokenContainer.get().containsKey((Object)attribute.getId());
                if (this.alwaysIncludedAttributes.contains(attribute.getId()) && !this.deniedUserInfoAttributes.contains(attribute.getId())) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (this.alwaysIncludedAttributes.contains(attribute.getId())) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getIdtokenClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (!this.deniedUserInfoAttributes.contains(attribute.getId())) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    if (requestedToIdToken) {
                        encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getClaims().setClaim(k, encodedAttribute.get(k)));
                        continue;
                    }
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getUserinfoClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (!requestedToIdToken || (encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule)) == null) continue;
                encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getIdtokenClaims().setClaim(k, encodedAttribute.get(k)));
            }
            catch (AttributeEncodingException e) {
                this.log.warn("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                if (this.ignoringUnencodableAttributes) continue;
                throw e;
            }
        }
    }
}

