/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import com.nimbusds.jose.jwk.JWKSet;
import java.net.URI;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.jwk.support.RemoteJwkUtils;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddJwksToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddJwksToClientMetadata.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private Predicate<ProfileRequestContext> validateRemoteJwkSetPredicate;

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        this.validateRemoteJwkSetPredicate = Predicates.alwaysTrue();
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    public void setValidateRemoteJwkSetPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.validateRemoteJwkSetPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate cannot be null");
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " HttpClient cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWKSet jwkSet = this.getInputMetadata().getJWKSet();
        URI jwkUri = this.getInputMetadata().getJWKSetURI();
        if (jwkSet != null && jwkUri != null) {
            this.log.warn("{} Both jwks and jwks_uri were defined", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        if (jwkSet != null) {
            if (this.containsKeys(jwkSet)) {
                this.getOutputMetadata().setJWKSet(jwkSet);
            } else {
                this.log.warn("{} The jwks was defined, but it doesn't contain any keys", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            }
            return;
        }
        if (jwkUri != null) {
            if (this.validateRemoteJwkSetPredicate.test(profileRequestContext)) {
                JWKSet remoteSet = RemoteJwkUtils.fetchRemoteJwkSet((String)this.getLogPrefix(), (URI)jwkUri, (HttpClient)this.httpClient, (HttpClientSecurityParameters)this.httpClientSecurityParameters);
                if (this.containsKeys(remoteSet)) {
                    this.log.debug("{} The jwks_uri endpoint available and contains key(s)", (Object)this.getLogPrefix());
                    this.getOutputMetadata().setJWKSetURI(jwkUri);
                } else {
                    this.log.warn("{} The jwks_uri was defined, but the endpoint does not contain key(s)", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                }
            } else {
                this.log.debug("{} The jwks_uri endpoint added to metadata without validation", (Object)this.getLogPrefix());
                this.getOutputMetadata().setJWKSetURI(jwkUri);
            }
            return;
        }
    }

    protected boolean containsKeys(JWKSet jwkSet) {
        if (jwkSet == null) {
            return false;
        }
        List keys = jwkSet.getKeys();
        return keys != null && !keys.isEmpty();
    }
}

