/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.velocity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.velocity.SpringResourceLoader;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class VelocityEngineFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(VelocityEngineFactory.class);
    @Nullable
    private Resource configLocation;
    @Nonnull
    private final Map<String, Object> velocityProperties = new HashMap<String, Object>();
    @Nullable
    private String resourceLoaderPath;
    @Nullable
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean preferFileSystemAccess = true;

    public void setConfigLocation(@Nullable Resource location) {
        this.configLocation = location;
    }

    public void setVelocityProperties(@Nullable Properties props) {
        CollectionUtils.mergePropertiesIntoMap((Properties)props, this.velocityProperties);
    }

    public void setVelocityPropertiesMap(@Nullable Map<String, Object> map) {
        if (map != null) {
            this.velocityProperties.putAll(map);
        }
    }

    public void setResourceLoaderPath(@Nullable String paths) {
        this.resourceLoaderPath = paths;
    }

    public void setResourceLoader(@Nullable ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    public void setPreferFileSystemAccess(boolean flag) {
        this.preferFileSystemAccess = flag;
    }

    @Nonnull
    public VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.configLocation != null) {
            this.log.info("Loading Velocity config from '{}'", (Object)this.configLocation);
            CollectionUtils.mergePropertiesIntoMap((Properties)PropertiesLoaderUtils.loadProperties((Resource)this.configLocation), props);
        }
        if (!this.velocityProperties.isEmpty()) {
            props.putAll(this.velocityProperties);
        }
        VelocityEngine velocityEngine = this.newVelocityEngine();
        if (this.resourceLoaderPath != null) {
            this.initVelocityResourceLoader(velocityEngine, this.resourceLoaderPath);
        }
        for (Map.Entry entry : props.entrySet()) {
            velocityEngine.setProperty((String)entry.getKey(), entry.getValue());
        }
        this.postProcessVelocityEngine(velocityEngine);
        velocityEngine.init();
        return velocityEngine;
    }

    @Nonnull
    protected VelocityEngine newVelocityEngine() throws IOException, VelocityException {
        return new VelocityEngine();
    }

    protected void initVelocityResourceLoader(@Nonnull VelocityEngine velocityEngine, @Nullable String loaderPath) {
        if (this.preferFileSystemAccess && this.resourceLoader != null) {
            ArrayList<String> filePaths = new ArrayList<String>();
            ArrayList<String> nonFilePaths = new ArrayList<String>();
            String[] paths = StringUtils.commaDelimitedListToStringArray((String)loaderPath);
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path.startsWith("classpath:")) {
                    this.log.debug("Using SpringResourceLoader for '{}'", (Object)path);
                    nonFilePaths.add(path);
                    continue;
                }
                try {
                    Resource resource = this.resourceLoader.getResource(path);
                    File file = resource.getFile();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Resource loader path '{}' resolved to file '{}'", (Object)path, (Object)file.getAbsolutePath());
                    }
                    filePaths.add(file.getAbsolutePath());
                    continue;
                }
                catch (IOException ex) {
                    this.log.debug("Cannot resolve resource loader path '{}' to filesystem, will use SpringResourceLoader", (Object)path, (Object)ex);
                    nonFilePaths.add(path);
                }
            }
            if (!filePaths.isEmpty()) {
                velocityEngine.setProperty("resource.loaders", (Object)"file");
                velocityEngine.setProperty("resource.loader.file.cache", (Object)"true");
                velocityEngine.setProperty("resource.loader.file.path", (Object)StringUtils.collectionToCommaDelimitedString(filePaths));
            }
            if (!nonFilePaths.isEmpty()) {
                this.initSpringResourceLoader(velocityEngine, StringUtils.collectionToCommaDelimitedString(nonFilePaths));
            }
        } else {
            this.log.debug("Filesystem access not preferred, will use SpringResourceLoader exclusively");
            this.initSpringResourceLoader(velocityEngine, loaderPath);
        }
    }

    protected void initSpringResourceLoader(@Nonnull VelocityEngine velocityEngine, @Nullable String path) {
        velocityEngine.addProperty("resource.loaders", (Object)"spring");
        velocityEngine.setProperty("resource.loader.spring.class", (Object)SpringResourceLoader.class.getName());
        velocityEngine.setProperty("resource.loader.spring.cache", (Object)"true");
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader", (Object)this.resourceLoader);
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader.path", (Object)path);
    }

    protected void postProcessVelocityEngine(@Nonnull VelocityEngine velocityEngine) throws IOException, VelocityException {
    }
}

