/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class PatternFactoryBean
extends AbstractComponentAwareFactoryBean<Pattern> {
    @Nullable
    private String caseSensitive;
    @Nullable
    private String regexp;

    public Class<?> getObjectType() {
        return Pattern.class;
    }

    public String getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(@Nullable String what) {
        Constraint.isNotNull((Object)what, (String)"caseSensitive cannot be null");
        this.caseSensitive = what;
    }

    @Nullable
    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(@Nonnull String what) {
        this.regexp = what;
    }

    @Override
    protected Pattern doCreateInstance() throws Exception {
        Boolean isCaseSensitive;
        Constraint.isNotNull((Object)this.regexp, (String)"Regular expression cannot be null");
        if (this.caseSensitive != null) {
            isCaseSensitive = StringSupport.booleanOf((String)this.caseSensitive);
            Constraint.isNotNull((Object)isCaseSensitive, (String)"caseSensitive cannot be null");
        } else {
            isCaseSensitive = true;
        }
        return Pattern.compile(this.regexp, isCaseSensitive != false ? 0 : 2);
    }
}

