/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Idp1326 {
    private String parentAsString;
    private String separator;
    private Resource resource;

    @BeforeClass
    public void getFileSystemDetails() throws IOException {
        this.resource = new ClassPathResource("net/shibboleth/ext/spring/resource/idp1326.xml");
        Path path = this.resource.getFile().toPath();
        this.separator = path.getFileSystem().getSeparator();
        Assert.assertEquals((int)this.separator.length(), (int)1);
        this.parentAsString = path.getParent().toAbsolutePath().toString();
    }

    @Test(enabled=false)
    public void testPropFileNative() {
        this.testPropFile(this.parentAsString);
    }

    @Test
    public void testPropFileJava() {
        StringBuilder sb = new StringBuilder(this.parentAsString);
        if (!"/".equals(this.separator)) {
            int i = sb.indexOf(this.separator);
            while (i > 0) {
                sb.replace(i, i + 1, "/");
                i = sb.indexOf(this.separator);
            }
        }
        this.testPropFile(sb.toString());
    }

    private void testPropFile(String idpHome) {
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext();
        MutablePropertySources propertySources = context.getEnvironment().getPropertySources();
        MockPropertySource mockEnvVars = new MockPropertySource();
        mockEnvVars.setProperty("idp.home", (Object)idpHome);
        propertySources.replace("systemProperties", (PropertySource)mockEnvVars);
        PropertySourcesPlaceholderConfigurer placeholderConfig = new PropertySourcesPlaceholderConfigurer();
        placeholderConfig.setPlaceholderPrefix("%{");
        placeholderConfig.setPlaceholderSuffix("}");
        placeholderConfig.setPropertySources((PropertySources)propertySources);
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfig);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions(this.resource);
        context.refresh();
        Collection beans = context.getBeansOfType(String.class).values();
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertEquals((String)((String)beans.iterator().next()), (String)idpHome);
    }
}

