/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.joda;

import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class FmtPeriod
extends CellProcessorAdaptor {
    private final PeriodFormatter formatter;

    public FmtPeriod() {
        this.formatter = null;
    }

    public FmtPeriod(CellProcessor next) {
        super(next);
        this.formatter = null;
    }

    public FmtPeriod(PeriodFormatter formatter) {
        FmtPeriod.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    public FmtPeriod(PeriodFormatter formatter, CellProcessor next) {
        super(next);
        FmtPeriod.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    private static void checkPreconditions(PeriodFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Period)) {
            throw new SuperCsvCellProcessorException(Period.class, value, context, (CellProcessor)this);
        }
        Period period = (Period)value;
        String result = this.formatter != null ? period.toString(this.formatter) : period.toString();
        return this.next.execute((Object)result, context);
    }
}

