/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sql.SQLColumn;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import org.w3c.dom.Node;

public class SQLInsert
extends StyleElement {
    Expression connection;
    String table;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string;
        this.table = this.getAttribute("table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        if ((string = this.getAttribute("connection")) == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Instruction compile() throws TransformerConfigurationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + this.table + " (");
        Node node = this.getFirstChild();
        int n = 0;
        while (node != null) {
            if (node instanceof SQLColumn) {
                if (n++ > 0) {
                    stringBuffer.append(',');
                }
                String string = ((SQLColumn)((Object)node)).getColumnName();
                stringBuffer.append(string);
            }
            node = node.getNextSibling();
        }
        stringBuffer.append(") VALUES (");
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
            ++n2;
        }
        stringBuffer.append(')');
        InsertInstruction insertInstruction = new InsertInstruction(this.connection, stringBuffer.toString(), this.getColumnInstructions());
        return insertInstruction;
    }

    public List getColumnInstructions() throws TransformerConfigurationException {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof SQLColumn) {
                arrayList.add(((SQLColumn)((Object)node)).compile());
            }
            node = node.getNextSibling();
        }
        return arrayList;
    }

    private static class InsertInstruction
    extends Instruction {
        Expression connectExpression;
        String statement;
        List columnInstructions;

        public InsertInstruction(Expression expression, String string, List list) {
            this.connectExpression = expression;
            this.statement = string;
            this.columnInstructions = list;
        }

        public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
            instructionDetails.setInstructionName("insert");
            instructionDetails.setProperty("instruction-namespace", (Object)"java:/net.sf.saxon.sql.SQLElementFactory");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Item item = this.connectExpression.evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue)) throw new TransformerException("Value of connection expression is not a JDBC Connection");
            if (!(((ObjectValue)item).getObject() instanceof Connection)) {
                throw new TransformerException("Value of connection expression is not a JDBC Connection");
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement(this.statement);
                    Iterator iterator = this.columnInstructions.iterator();
                    int n = 1;
                    while (true) {
                        if (!iterator.hasNext()) {
                            preparedStatement.executeUpdate();
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                            break;
                        }
                        AtomicValue atomicValue = (AtomicValue)((SQLColumn.ColumnInstruction)((Object)iterator.next())).getSelectValue(xPathContext);
                        String string = atomicValue.getStringValue();
                        if (string.length() == 1) {
                            string = string + " ";
                        }
                        preparedStatement.setObject(n++, string);
                    }
                }
                catch (SQLException sQLException) {
                    throw this.styleError("(SQL) " + sQLException.getMessage(), controller);
                }
                Object var11_11 = null;
                if (preparedStatement == null) return null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (preparedStatement == null) throw throwable;
                try {
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            preparedStatement.close();
            return null;
        }
    }
}

