/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.pdf.classic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.pdf.classic.ClassicChunk;
import net.sf.jasperreports.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.pdf.classic.ClassicPdfUtils;
import net.sf.jasperreports.pdf.common.PdfChunk;
import net.sf.jasperreports.pdf.common.PdfPhrase;
import net.sf.jasperreports.pdf.common.PdfTextAlignment;
import net.sf.jasperreports.pdf.common.TextDirection;

public class ClassicPhrase
implements PdfPhrase {
    private ClassicPdfProducer pdfProducer;
    private Phrase phrase;

    public ClassicPhrase(ClassicPdfProducer pdfProducer, Phrase phrase) {
        this.pdfProducer = pdfProducer;
        this.phrase = phrase;
    }

    @Override
    public void add(PdfChunk chunk) {
        this.phrase.add((Element)((ClassicChunk)chunk).getChunk());
    }

    @Override
    public float go(float llx, float lly, float urx, float ury, float fixedLeading, float multipliedLeading, PdfTextAlignment alignment, TextDirection runDirection) {
        ColumnText colText = new ColumnText(this.pdfProducer.getPdfContentByte());
        colText.setSimpleColumn(this.phrase, llx, lly, urx, ury, fixedLeading, ClassicPdfUtils.toPdfAlignment(alignment));
        if (multipliedLeading != 0.0f) {
            colText.setLeading(fixedLeading, multipliedLeading);
        }
        colText.setRunDirection(ClassicPhrase.toPdfRunDirection(runDirection));
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return colText.getYLine();
    }

    protected static int toPdfRunDirection(TextDirection direction) {
        int pdfDirection;
        switch (direction) {
            case DEFAULT: {
                pdfDirection = 0;
                break;
            }
            case LTR: {
                pdfDirection = 2;
                break;
            }
            case RTL: {
                pdfDirection = 3;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown text direction " + (Object)((Object)direction));
            }
        }
        return pdfDirection;
    }
}

