/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.xmla.XmlaDataAdapter;
import net.sf.jasperreports.dataadapters.AbstractDataAdapterService;
import net.sf.jasperreports.dataadapters.DataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;

public class XmlaDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(XmlaDataAdapterService.class);
    public static final String EXCEPTION_MESSAGE_KEY_XMLA_CONNECTION = "data.xmla.connection";

    public XmlaDataAdapterService(ParameterContributorContext paramContribContext, XmlaDataAdapter dataAdapter) {
        super(paramContribContext, (DataAdapter)dataAdapter);
    }

    public XmlaDataAdapter getXmlaDataAdapter() {
        return (XmlaDataAdapter)this.getDataAdapter();
    }

    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XmlaDataAdapter xmlaDA = this.getXmlaDataAdapter();
        if (xmlaDA != null) {
            parameters.put("XMLA_URL", xmlaDA.getXmlaUrl());
            parameters.put("XMLA_DATASOURCE", xmlaDA.getDatasource());
            parameters.put("XMLA_CATALOG", xmlaDA.getCatalog());
            String username = xmlaDA.getUsername();
            if (username != null && !username.isEmpty()) {
                parameters.put("XMLA_USER", username);
            }
            String password = xmlaDA.getPassword();
            SecretsUtil secretService = SecretsUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
            if (secretService != null) {
                password = secretService.getSecret("net.sf.jasperreports.data.adapter", password);
            }
            if (password != null && !password.isEmpty()) {
                parameters.put("XMLA_PASSWORD", password);
            }
        }
    }

    public void test() throws JRException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.contributeParameters(params);
        Properties props = new Properties();
        this.putNonNull(props, "server", params.get("XMLA_URL"));
        this.putNonNull(props, "catalog", params.get("XMLA_CATALOG"));
        this.putNonNull(props, "dataSource", params.get("XMLA_DATASOURCE"));
        this.putNonNull(props, "user", params.get("XMLA_USER"));
        this.putNonNull(props, "password", params.get("XMLA_PASSWORD"));
        this.putNonNull(props, "olap4jDriver", "org.olap4j.driver.xmla.XmlaOlap4jDriver");
        this.putNonNull(props, "urlPrefix", "jdbc:xmla:");
        try {
            ResultSet datasources;
            Connection connection;
            block9: {
                Method method;
                OlapDatabaseMetaData metaData;
                block8: {
                    Class.forName("org.olap4j.driver.xmla.XmlaOlap4jDriver");
                    connection = DriverManager.getConnection("jdbc:xmla:", props);
                    OlapConnection olapConnection = connection.unwrap(OlapConnection.class);
                    metaData = olapConnection.getMetaData();
                    datasources = null;
                    try {
                        method = OlapDatabaseMetaData.class.getMethod("getDatabases", new Class[0]);
                        datasources = (ResultSet)method.invoke((Object)metaData, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)("OlapDatabaseMetaData.getDatabases method not found: " + e.getMessage()));
                    }
                }
                if (datasources == null) {
                    try {
                        method = OlapDatabaseMetaData.class.getMethod("getDatasources", new Class[0]);
                        datasources = (ResultSet)method.invoke((Object)metaData, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        if (!log.isDebugEnabled()) break block9;
                        log.debug((Object)("OlapDatabaseMetaData.getDatasources method not found: " + e.getMessage()));
                    }
                }
            }
            if (datasources != null) {
                datasources.next();
                datasources.close();
            }
            connection.close();
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException | SQLException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_XMLA_CONNECTION, null, (Throwable)e);
        }
        this.dispose();
    }

    private void putNonNull(Properties props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }
}

