/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.groovy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class GroovyClassFilterTransformer
extends SandboxTransformer {
    private static final Log log = LogFactory.getLog(GroovyClassFilterTransformer.class);
    private static final Set<String> BUILTIN_ALLOWED_TYPES = new HashSet<String>();

    protected boolean allowed(ClassNode type) {
        return BUILTIN_ALLOWED_TYPES.contains(type.getName());
    }

    public ClassCodeExpressionTransformer createVisitor(SourceUnit source, ClassNode clazz) {
        return new Transformer(source, clazz);
    }

    static {
        BUILTIN_ALLOWED_TYPES.add("char");
        BUILTIN_ALLOWED_TYPES.add("byte");
        BUILTIN_ALLOWED_TYPES.add("short");
        BUILTIN_ALLOWED_TYPES.add("int");
        BUILTIN_ALLOWED_TYPES.add("long");
        BUILTIN_ALLOWED_TYPES.add("float");
        BUILTIN_ALLOWED_TYPES.add("double");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Boolean");
        BUILTIN_ALLOWED_TYPES.add("java.lang.String");
        BUILTIN_ALLOWED_TYPES.add("java.lang.StringBuffer");
        BUILTIN_ALLOWED_TYPES.add("java.lang.StringBuilder");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Character");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Byte");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Short");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Integer");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Long");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Float");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Double");
        BUILTIN_ALLOWED_TYPES.add("java.lang.Math");
    }

    protected class Transformer
    extends SandboxTransformer.VisitorImpl {
        protected Transformer(SourceUnit sourceUnit, ClassNode clazz) {
            super((SandboxTransformer)GroovyClassFilterTransformer.this, sourceUnit, clazz);
        }

        protected Expression transformBinaryExpression(String checkedOperation, BinaryExpression be) {
            Expression leftExpression = be.getLeftExpression();
            Expression rightExpression = be.getRightExpression();
            if (GroovyClassFilterTransformer.this.allowed(leftExpression.getType()) && GroovyClassFilterTransformer.this.allowed(rightExpression.getType())) {
                Expression transformedLeft = this.transform(leftExpression);
                Expression transformedRight = this.transform(rightExpression);
                if (transformedLeft.equals(leftExpression) && transformedRight.equals(rightExpression)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("allowed binary expression " + be));
                    }
                    return be;
                }
                BinaryExpression transformedExpression = new BinaryExpression(transformedLeft, be.getOperation(), transformedRight);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("transformed binary expression " + transformedExpression));
                }
                return transformedExpression;
            }
            return super.transformBinaryExpression(checkedOperation, be);
        }

        protected Expression transformConstructorCall(ConstructorCallExpression exp) {
            if (GroovyClassFilterTransformer.this.allowed(exp.getType())) {
                Expression originalArgs = exp.getArguments();
                Expression transformedArgs = this.transformArguments(originalArgs);
                Expression unwrappedArgs = this.unwrapTransformedArguments(transformedArgs, originalArgs);
                if (unwrappedArgs.equals(originalArgs)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("allowed constructor call " + exp));
                    }
                    return exp;
                }
                ConstructorCallExpression transformedCall = new ConstructorCallExpression(exp.getType(), unwrappedArgs);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("transformed constructor call " + transformedCall));
                }
                return transformedCall;
            }
            return super.transformConstructorCall(exp);
        }

        protected Expression transformMethodCall(MethodCallExpression originalCall, Expression transformedObject, Expression transformedMethod, Expression transformedArgs) {
            Expression originalObject = originalCall.getObjectExpression();
            if (GroovyClassFilterTransformer.this.allowed(originalObject.getType())) {
                Expression originalMethod = originalCall.getMethod();
                Expression originalArgs = originalCall.getArguments();
                Expression unwrappedArgs = this.unwrapTransformedArguments(transformedArgs, originalArgs);
                if (unwrappedArgs != null) {
                    if (transformedObject.equals(originalObject) && transformedMethod.equals(originalMethod) && unwrappedArgs.equals(originalArgs)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("allowed method call " + originalCall));
                        }
                        return originalCall;
                    }
                    MethodCallExpression transformedCall = new MethodCallExpression(transformedObject, transformedMethod, unwrappedArgs);
                    transformedCall.setSafe(originalCall.isSafe());
                    transformedCall.setSpreadSafe(originalCall.isSpreadSafe());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("transformed method call " + transformedCall));
                    }
                    return transformedCall;
                }
            }
            return super.transformMethodCall(originalCall, transformedObject, transformedMethod, transformedArgs);
        }

        protected Expression unwrapTransformedArguments(Expression transformedArgs, Expression originalArgs) {
            if (!(transformedArgs instanceof MethodCallExpression)) {
                return null;
            }
            MethodCallExpression transformedArgsCall = (MethodCallExpression)transformedArgs;
            Expression transformedObject = transformedArgsCall.getObjectExpression();
            Expression transformedMethod = transformedArgsCall.getMethod();
            if (!(transformedObject instanceof ListExpression && transformedMethod instanceof ConstantExpression && "toArray".equals(transformedMethod.getText()))) {
                return null;
            }
            List transformedExpressions = ((ListExpression)transformedObject).getExpressions();
            if (originalArgs instanceof ArgumentListExpression) {
                List originalExpressions = ((ArgumentListExpression)originalArgs).getExpressions();
                if (transformedExpressions.equals(originalExpressions)) {
                    return originalArgs;
                }
                return new ArgumentListExpression(transformedExpressions);
            }
            return null;
        }
    }
}

