/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.fastexcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.Sheet;

public class FastExcelDataSource
extends AbstractXlsDataSource {
    private ReadableWorkbook workbook;
    private Iterator<Sheet> sheets;
    private Iterator<Row> rows;
    private Sheet sheet;
    private Row row;
    private int rowNumber = 0;
    private InputStream inputStream;
    private boolean closeWorkbook;
    private boolean closeInputStream;

    public FastExcelDataSource(ReadableWorkbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public FastExcelDataSource(InputStream is) throws JRException, IOException {
        this.inputStream = is;
        this.closeWorkbook = true;
        this.closeInputStream = false;
        this.workbook = this.loadWorkbook(this.inputStream);
    }

    public FastExcelDataSource(InputStream is, boolean closeInputStream) throws JRException, IOException {
        this.inputStream = is;
        this.closeWorkbook = true;
        this.closeInputStream = closeInputStream;
        this.workbook = this.loadWorkbook(this.inputStream);
    }

    public FastExcelDataSource(File file) throws JRException, IOException {
        this(new FileInputStream(file));
        this.closeInputStream = true;
    }

    public FastExcelDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this((RepositoryContext)SimpleRepositoryContext.of((JasperReportsContext)jasperReportsContext), location);
    }

    public FastExcelDataSource(RepositoryContext context, String location) throws JRException, IOException {
        this(RepositoryUtil.getInstance((RepositoryContext)context).getInputStreamFromLocation(location));
        this.closeInputStream = true;
    }

    public FastExcelDataSource(String location) throws JRException, IOException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), location);
    }

    protected ReadableWorkbook loadWorkbook(InputStream is) throws IOException {
        return new ReadableWorkbook(is);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() throws JRException {
        boolean isFirstRow;
        if (this.workbook == null) return false;
        boolean bl = isFirstRow = this.sheets == null;
        if (this.sheets == null) {
            if (this.sheetSelection == null) {
                this.sheets = this.workbook.getSheets().iterator();
                if (!this.sheets.hasNext()) return false;
                this.sheet = this.sheets.next();
            } else {
                Sheet selectedSheet = null;
                try {
                    int sheetIndex = Integer.parseInt(this.sheetSelection);
                    selectedSheet = (Sheet)this.workbook.getSheet(sheetIndex).get();
                    if (selectedSheet == null) {
                        throw new JRRuntimeException("data.xls.sheet.not.found", new Object[]{this.sheetSelection});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (selectedSheet == null && (selectedSheet = (Sheet)this.workbook.findSheet(this.sheetSelection).get()) == null) {
                    throw new JRRuntimeException("data.xls.sheet.not.found", new Object[]{this.sheetSelection});
                }
                this.sheets = Collections.singletonList(selectedSheet).iterator();
                this.sheet = this.sheets.next();
            }
        }
        if (this.rows == null) {
            try {
                this.rows = this.sheet.openStream().iterator();
            }
            catch (IOException e) {
                throw new JRException((Throwable)e);
            }
        }
        if (this.rows.hasNext()) {
            this.row = this.rows.next();
            ++this.rowNumber;
        } else {
            if (!this.sheets.hasNext()) return false;
            this.sheet = this.sheets.next();
            this.rows = null;
            this.rowNumber = 0;
            return this.next();
        }
        if (!isFirstRow || !this.useFirstRowAsHeader) return true;
        this.readHeader();
        return this.next();
    }

    public void moveFirst() {
        this.sheets = null;
        this.rows = null;
        this.rowNumber = 0;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Class valueClass = jrField.getValueClass();
        try {
            Integer columnIndex = this.getColumnIndex(jrField);
            Cell cell = this.row.getCell(columnIndex.intValue());
            if (cell == null) {
                return null;
            }
            CellType cellType = cell.getType();
            if (cellType == CellType.FORMULA) {
                return cell.getValue();
            }
            if (cellType == CellType.EMPTY) {
                return null;
            }
            if (valueClass.equals(String.class)) {
                if (cellType == CellType.STRING) {
                    return cell.asString();
                }
                return cell.getText();
            }
            if (valueClass.equals(Boolean.class)) {
                if (cellType == CellType.BOOLEAN) {
                    return cell.asBoolean();
                }
                String value = cell.asString();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                return this.convertStringValue(value, valueClass);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                if (cellType == CellType.NUMBER) {
                    return this.convertNumber(cell.asNumber(), valueClass);
                }
                String value = cell.asString();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                if (this.numberFormat != null) {
                    return FormatUtils.getFormattedNumber((NumberFormat)this.numberFormat, (String)value, (Class)valueClass);
                }
                return this.convertStringValue(value, valueClass);
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                if (cellType == CellType.NUMBER) {
                    return Timestamp.valueOf(cell.asDate());
                }
                String value = cell.asString();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate((DateFormat)this.dateFormat, (String)value, (Class)valueClass);
                }
                return this.convertStringValue(value, valueClass);
            }
            if (LocalDateTime.class.isAssignableFrom(valueClass)) {
                if (cellType == CellType.NUMBER) {
                    return cell.asDate();
                }
                String value = cell.asString();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate((DateFormat)this.dateFormat, (String)value, (Class)valueClass);
                }
                return this.convertStringValue(value, valueClass);
            }
            throw new JRException("data.common.cannot.convert.field.type", new Object[]{jrField.getName(), valueClass.getName(), "[Sheet:" + this.sheet.getName() + ", Row:" + this.rowNumber + "]"});
        }
        catch (Exception e) {
            throw new JRException("data.xls.field.value.not.retrieved", new Object[]{jrField.getName(), valueClass.getName(), "[Sheet:" + this.sheet.getName() + ", Row:" + this.rowNumber + "]"}, (Throwable)e);
        }
    }

    private void readHeader() {
        if (this.columnNames.size() == 0) {
            int columnIndex = 0;
            for (Cell cell : this.row) {
                if (cell != null) {
                    this.columnNames.put(cell.asString(), columnIndex);
                } else {
                    this.columnNames.put("COLUMN_" + columnIndex, columnIndex);
                }
                ++columnIndex;
            }
        } else {
            LinkedHashMap<String, Integer> newColumnNames = new LinkedHashMap<String, Integer>();
            for (Integer columnIndex : this.columnNames.values()) {
                Cell cell = this.row.getCell(columnIndex.intValue());
                if (cell == null) continue;
                if (cell.getType() == CellType.STRING) {
                    newColumnNames.put(cell.asString(), columnIndex);
                    continue;
                }
                newColumnNames.put(cell.getText(), columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
            if (this.closeWorkbook && this.workbook != null) {
                this.workbook.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void checkReadStarted() {
        if (this.sheet != null) {
            throw new JRRuntimeException("data.common.cannot.modify.properties.after.start", (Object[])null);
        }
    }

    public String getStringFieldValue(JRField jrField) throws JRException {
        try {
            Integer columnIndex = this.getColumnIndex(jrField);
            Cell cell = this.row.getCell(columnIndex.intValue());
            if (cell == null) {
                return null;
            }
            return cell.asString();
        }
        catch (Exception e) {
            throw new JRException("data.xls.field.value.not.retrieved", new Object[]{jrField.getName(), String.class.getName(), "[Sheet:" + this.sheet.getName() + ", Row:" + this.rowNumber + "]"}, (Throwable)e);
        }
    }

    public String getFieldFormatPattern(JRField jrField) throws JRException {
        try {
            Integer columnIndex = this.getColumnIndex(jrField);
            Cell cell = this.row.getCell(columnIndex.intValue());
            if (cell == null) {
                return null;
            }
            return cell.getDataFormatString();
        }
        catch (Exception e) {
            throw new JRException("data.xls.field.value.not.retrieved", new Object[]{jrField.getName(), String.class.getName(), "[Sheet:" + this.sheet.getName() + ", Row:" + this.rowNumber + "]"}, (Throwable)e);
        }
    }
}

