/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xml;

import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.dataadapters.AbstractDataAdapterService;
import net.sf.jasperreports.dataadapters.DataAdapter;
import net.sf.jasperreports.dataadapters.DataFileStream;
import net.sf.jasperreports.dataadapters.DataFileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.util.Designated;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

public class XmlDataAdapterService
extends AbstractDataAdapterService
implements Designated {
    public static final String SERVICE_DESIGNATION = "net.sf.jasperreports.data.adapter:XML";

    public XmlDataAdapterService(ParameterContributorContext paramContribContext, XmlDataAdapter xmlDataAdapter) {
        super(paramContribContext, (DataAdapter)xmlDataAdapter);
    }

    public XmlDataAdapter getXmlDataAdapter() {
        return (XmlDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XmlDataAdapter xmlDataAdapter = this.getXmlDataAdapter();
        if (xmlDataAdapter != null) {
            Document dataDocument = this.loadDataDocument(xmlDataAdapter, parameters);
            if (xmlDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                parameters.put("XML_DATA_DOCUMENT", dataDocument);
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("XML_LOCALE", locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    parameters.put("XML_TIME_ZONE", timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("XML_DATE_PATTERN", datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("XML_NUMBER_PATTERN", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JRXmlDataSource ds = new JRXmlDataSource(this.getJasperReportsContext(), dataDocument, xmlDataAdapter.getSelectExpression());
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDataDocument(XmlDataAdapter xmlDataAdapter, Map<String, Object> parameters) throws JRException {
        DataFileUtils dataFileUtils = DataFileUtils.instance(this.getParameterContributorContext());
        DataFileStream dataStream = dataFileUtils.getDataStream(xmlDataAdapter.getDataFile(), parameters);
        try {
            Document dataDocument;
            Document document = dataDocument = JRXmlUtils.parse((InputStream)dataStream, (boolean)xmlDataAdapter.isNamespaceAware());
            return document;
        }
        finally {
            dataStream.dispose();
        }
    }

    public String getDesignation() {
        return SERVICE_DESIGNATION;
    }
}

