/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.TextAnchor;

public class ScaledDialScale
extends StandardDialScale {
    private static final long serialVersionUID = 10200L;

    public ScaledDialScale() {
    }

    public ScaledDialScale(double lowerBound, double upperBound, double startAngle, double extent, double majorTickIncrement, int minorTickCount) {
        super(lowerBound, upperBound, startAngle, extent, majorTickIncrement, minorTickCount);
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Rectangle2D arcRect = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getTickRadius(), (double)this.getTickRadius());
        Rectangle2D arcRectMajor = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getMajorTickLength()), (double)(this.getTickRadius() - this.getMajorTickLength()));
        Rectangle2D arcRectMinor = arcRect;
        if (this.getMinorTickCount() > 0 && this.getMinorTickLength() > 0.0) {
            arcRectMinor = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getMinorTickLength()), (double)(this.getTickRadius() - this.getMinorTickLength()));
        }
        Rectangle2D arcRectForLabels = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)(this.getTickRadius() - this.getTickLabelOffset()), (double)(this.getTickRadius() - this.getTickLabelOffset()));
        boolean firstLabel = true;
        Arc2D.Double arc = new Arc2D.Double();
        Line2D.Double workingLine = new Line2D.Double();
        BasicStroke arcStroke = new BasicStroke(0.75f);
        for (double v = this.getLowerBound(); v <= this.getUpperBound(); v += this.getMajorTickIncrement()) {
            double vv;
            arc.setArc(arcRect, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
            g2.setPaint(this.getMajorTickPaint());
            g2.setStroke(arcStroke);
            g2.draw(arc);
            Point2D pt0 = arc.getEndPoint();
            arc.setArc(arcRectMajor, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
            Point2D pt1 = arc.getEndPoint();
            g2.setPaint(this.getMajorTickPaint());
            g2.setStroke(this.getMajorTickStroke());
            workingLine.setLine(pt0, pt1);
            g2.draw(workingLine);
            arc.setArc(arcRectForLabels, this.getStartAngle(), this.valueToAngle(v) - this.getStartAngle(), 0);
            Point2D pt2 = arc.getEndPoint();
            if (this.getTickLabelsVisible() && (!firstLabel || this.getFirstTickLabelVisible())) {
                g2.setFont(this.getTickLabelFont());
                TextUtils.drawAlignedString((String)this.getTickLabelFormatter().format(v), (Graphics2D)g2, (float)((float)pt2.getX()), (float)((float)pt2.getY()), (TextAnchor)TextAnchor.CENTER);
            }
            firstLabel = false;
            if (this.getMinorTickCount() <= 0 || !(this.getMinorTickLength() > 0.0)) continue;
            double minorTickIncrement = this.getMajorTickIncrement() / (double)(this.getMinorTickCount() + 1);
            for (int i = 0; i < this.getMinorTickCount() && !((vv = v + (double)(i + 1) * minorTickIncrement) >= this.getUpperBound()); ++i) {
                double angle = this.valueToAngle(vv);
                arc.setArc(arcRect, this.getStartAngle(), angle - this.getStartAngle(), 0);
                pt0 = arc.getEndPoint();
                arc.setArc(arcRectMinor, this.getStartAngle(), angle - this.getStartAngle(), 0);
                Point2D pt3 = arc.getEndPoint();
                g2.setStroke(this.getMinorTickStroke());
                g2.setPaint(this.getMinorTickPaint());
                workingLine.setLine(pt0, pt3);
                g2.draw(workingLine);
            }
        }
    }
}

