/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.StandardGradientPaintTransformer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

class GradientXYBubbleRenderer
extends XYBubbleRenderer {
    private static final long serialVersionUID = 10200L;

    public GradientXYBubbleRenderer(int scaleType) {
        super(scaleType);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double x = dataset.getXValue(series, item);
        double y = dataset.getYValue(series, item);
        double z = Double.NaN;
        if (dataset instanceof XYZDataset) {
            XYZDataset xyzData = (XYZDataset)dataset;
            z = xyzData.getZValue(series, item);
        }
        if (!Double.isNaN(z)) {
            RectangleEdge domainAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
            double transX = domainAxis.valueToJava2D(x, dataArea, domainAxisLocation);
            double transY = rangeAxis.valueToJava2D(y, dataArea, rangeAxisLocation);
            double transDomain = 0.0;
            double transRange = 0.0;
            switch (this.getScaleType()) {
                case 1: {
                    double zero = domainAxis.valueToJava2D(0.0, dataArea, domainAxisLocation);
                    transRange = transDomain = domainAxis.valueToJava2D(z, dataArea, domainAxisLocation) - zero;
                    break;
                }
                case 2: {
                    double zero = rangeAxis.valueToJava2D(0.0, dataArea, rangeAxisLocation);
                    transDomain = transRange = zero - rangeAxis.valueToJava2D(z, dataArea, rangeAxisLocation);
                    break;
                }
                default: {
                    double zero1 = domainAxis.valueToJava2D(0.0, dataArea, domainAxisLocation);
                    double zero2 = rangeAxis.valueToJava2D(0.0, dataArea, rangeAxisLocation);
                    transDomain = domainAxis.valueToJava2D(z, dataArea, domainAxisLocation) - zero1;
                    transRange = zero2 - rangeAxis.valueToJava2D(z, dataArea, rangeAxisLocation);
                }
            }
            transDomain = Math.abs(transDomain);
            transRange = Math.abs(transRange);
            Ellipse2D.Double circle = null;
            if (orientation == PlotOrientation.VERTICAL) {
                circle = new Ellipse2D.Double(transX - transDomain / 2.0, transY - transRange / 2.0, transDomain, transRange);
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                circle = new Ellipse2D.Double(transY - transRange / 2.0, transX - transDomain / 2.0, transRange, transDomain);
            }
            Paint paint = this.getItemPaint(series, item);
            if (paint instanceof GradientPaint) {
                paint = new StandardGradientPaintTransformer().transform((GradientPaint)paint, (Shape)circle);
            }
            g2.setPaint(paint);
            g2.fill(circle);
            g2.setStroke(this.getItemOutlineStroke(series, item));
            g2.setPaint(this.getItemOutlinePaint(series, item));
            g2.draw(circle);
            if (this.isItemLabelVisible(series, item)) {
                if (orientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(g2, orientation, dataset, series, item, transX, transY, false);
                } else if (orientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(g2, orientation, dataset, series, item, transY, transX, false);
                }
            }
            EntityCollection entities = null;
            if (info != null && (entities = info.getOwner().getEntityCollection()) != null && circle.intersects(dataArea)) {
                this.addEntity(entities, circle, dataset, series, item, circle.getCenterX(), circle.getCenterY());
            }
            int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
            int n = plot.getRangeAxisIndex(rangeAxis);
        }
    }
}

