/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.StandardGradientPaintTransformer;
import org.jfree.data.category.CategoryDataset;

class GradientBarRenderer3D
extends BarRenderer {
    private static final long serialVersionUID = 10200L;

    public GradientBarRenderer3D(BarRenderer barRenderer3D) {
        this.setDefaultItemLabelGenerator(barRenderer3D.getDefaultItemLabelGenerator());
        this.setDefaultItemLabelsVisible(barRenderer3D.getDefaultItemLabelsVisible());
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        double x2;
        double x0;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        Rectangle2D.Double adjusted = new Rectangle2D.Double(dataArea.getX(), dataArea.getY(), dataArea.getWidth(), dataArea.getHeight());
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = this.calculateBarW0(plot, orientation, adjusted, domainAxis, state, row, column);
        double[] barL0L1 = this.calculateBarL0L1(value);
        if (barL0L1 == null) {
            return;
        }
        RectangleEdge edge = plot.getRangeAxisEdge();
        double transL0 = rangeAxis.valueToJava2D(barL0L1[0], (Rectangle2D)adjusted, edge);
        double transL1 = rangeAxis.valueToJava2D(barL0L1[1], (Rectangle2D)adjusted, edge);
        double barL0 = Math.min(transL0, transL1);
        double barLength = Math.abs(transL1 - transL0);
        Rectangle2D.Double bar = null;
        bar = orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(barL0, barW0, barLength, state.getBarWidth()) : new Rectangle2D.Double(barW0, barL0, state.getBarWidth(), barLength);
        Paint itemPaint = this.getItemPaint(row, column);
        if (itemPaint instanceof GradientPaint) {
            itemPaint = this.getGradientPaintTransformer().transform((GradientPaint)itemPaint, (Shape)bar);
        }
        g2.setPaint(itemPaint);
        g2.fill(bar);
        double x1 = x0 = bar.getMinX();
        double x3 = x2 = bar.getMaxX();
        double y0 = bar.getMinY();
        double y1 = bar.getMinY();
        double y2 = bar.getMaxY();
        double y3 = bar.getMaxY();
        GeneralPath bar3dRight = null;
        GeneralPath bar3dTop = null;
        if (barLength > 0.0) {
            bar3dRight = new GeneralPath();
            bar3dRight.moveTo((float)x2, (float)y3);
            bar3dRight.lineTo((float)x2, (float)y1);
            bar3dRight.lineTo((float)x3, (float)y0);
            bar3dRight.lineTo((float)x3, (float)y2);
            bar3dRight.closePath();
            if (itemPaint instanceof Color) {
                g2.setPaint(((Color)itemPaint).darker());
            } else if (itemPaint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)itemPaint;
                g2.setPaint(new StandardGradientPaintTransformer().transform(new GradientPaint(gp.getPoint1(), gp.getColor1().darker(), gp.getPoint2(), gp.getColor2().darker(), gp.isCyclic()), (Shape)bar3dRight));
            }
            g2.fill(bar3dRight);
        }
        bar3dTop = new GeneralPath();
        bar3dTop.moveTo((float)x0, (float)y1);
        bar3dTop.lineTo((float)x1, (float)y0);
        bar3dTop.lineTo((float)x3, (float)y0);
        bar3dTop.lineTo((float)x2, (float)y1);
        bar3dTop.closePath();
        g2.fill(bar3dTop);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            g2.setStroke(this.getItemOutlineStroke(row, column));
            g2.setPaint(this.getItemOutlinePaint(row, column));
            g2.draw(bar);
            if (bar3dRight != null) {
                g2.draw(bar3dRight);
            }
            if (bar3dTop != null) {
                g2.draw(bar3dTop);
            }
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, generator, bar, value < 0.0);
        }
        if ((entities = state.getEntityCollection()) != null) {
            GeneralPath barOutline = new GeneralPath();
            barOutline.moveTo((float)x0, (float)y3);
            barOutline.lineTo((float)x0, (float)y1);
            barOutline.lineTo((float)x1, (float)y0);
            barOutline.lineTo((float)x3, (float)y0);
            barOutline.lineTo((float)x3, (float)y2);
            barOutline.lineTo((float)x2, (float)y3);
            barOutline.closePath();
            this.addItemEntity(entities, dataset, row, column, barOutline);
        }
    }
}

