/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.chartthemes.ChartThemeMapBundle;
import net.sf.jasperreports.chartthemes.simple.ChartThemeBundlesExtensionsRegistry;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartTheme;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;

public class XmlChartThemeExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    public static final String XML_CHART_THEME_PROPERTY_PREFIX = "net.sf.jasperreports.xml.chart.theme.";
    public static final String PROPERTY_XML_CHART_THEME_REGISTRY_FACTORY = "net.sf.jasperreports.extension.registry.factory.xml.chart.themes";

    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        List themeProperties = JRPropertiesUtil.getProperties((JRPropertiesMap)properties, (String)XML_CHART_THEME_PROPERTY_PREFIX);
        HashMap<String, ChartTheme> themes = new HashMap<String, ChartTheme>();
        for (JRPropertiesUtil.PropertySuffix themeProp : themeProperties) {
            String themeName = themeProp.getSuffix();
            String themeLocation = themeProp.getValue();
            XmlChartTheme theme = new XmlChartTheme(themeLocation);
            themes.put(themeName, theme);
        }
        ChartThemeMapBundle bundle = new ChartThemeMapBundle();
        bundle.setThemes(themes);
        return new ChartThemeBundlesExtensionsRegistry(bundle);
    }

    public static void saveToJar(ChartThemeSettings settings, String themeName, File file) throws IOException {
        XmlChartThemeExtensionsRegistryFactory.saveToJar((JasperReportsContext)DefaultJasperReportsContext.getInstance(), settings, themeName, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToJar(JasperReportsContext jasperReportsContext, ChartThemeSettings settings, String themeName, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ZipOutputStream zipos = new ZipOutputStream(fos);
            zipos.setMethod(8);
            ZipEntry propsEntry = new ZipEntry("jasperreports_extension.properties");
            zipos.putNextEntry(propsEntry);
            Properties props = new Properties();
            props.put(PROPERTY_XML_CHART_THEME_REGISTRY_FACTORY, XmlChartThemeExtensionsRegistryFactory.class.getName());
            props.put(XML_CHART_THEME_PROPERTY_PREFIX + themeName, themeName + ".jrctx");
            props.store(zipos, null);
            ZipEntry jrctxEntry = new ZipEntry(themeName + ".jrctx");
            zipos.putNextEntry(jrctxEntry);
            OutputStreamWriter jrctxWriter = new OutputStreamWriter(zipos);
            XmlChartTheme.saveSettings(jasperReportsContext, settings, jrctxWriter);
            jrctxWriter.flush();
            zipos.flush();
            zipos.finish();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

