/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barcode4j;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.barcode4j.BarcodeComponent;
import net.sf.jasperreports.barcode4j.BarcodeEvaluator;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.renderers.Renderable;

public class BarcodeFillComponent
extends BaseFillComponent {
    private final BarcodeComponent barcodeComponent;
    private final Map<JRStyle, JRTemplateImage> printTemplates = new HashMap<JRStyle, JRTemplateImage>();
    private Renderable renderable;

    public BarcodeFillComponent(BarcodeComponent barcodeComponent) {
        this.barcodeComponent = barcodeComponent;
    }

    public BarcodeFillComponent(BarcodeFillComponent barcode) {
        this.barcodeComponent = barcode.barcodeComponent;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateBarcode(evaluation);
        }
    }

    protected boolean isEvaluateNow() {
        return EvaluationTimeEnum.getValueOrDefault((EvaluationTimeEnum)this.barcodeComponent.getEvaluationTime()) == EvaluationTimeEnum.NOW;
    }

    protected void evaluateBarcode(byte evaluation) {
        BarcodeEvaluator evaluator = new BarcodeEvaluator(this.fillContext, evaluation);
        evaluator.evaluateBarcode();
        this.renderable = evaluator.getRenderable();
    }

    public FillPrepareResult prepare(int availableHeight) {
        return this.prepare(availableHeight, true);
    }

    public FillPrepareResult prepare(int availableHeight, boolean isOverflowAllowed) {
        if (this.isEvaluateNow() && this.renderable == null) {
            return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
        }
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRPrintElement fill() {
        JRTemplateImage templateImage = this.getTemplateImage();
        JRTemplatePrintImage image = new JRTemplatePrintImage(templateImage, this.printElementOriginator);
        JRComponentElement element = this.fillContext.getComponentElement();
        image.setUUID(element.getUUID());
        image.setX(element.getX());
        image.setY(this.fillContext.getElementPrintY());
        image.setWidth(element.getWidth());
        image.setHeight(element.getHeight());
        HtmlReportConfiguration.forceEmbedImage((JRPropertiesUtil)this.fillContext.getFiller().getPropertiesUtil(), (JRPropertiesHolder)this.fillContext.getComponentElement(), (JRPropertiesHolder)image);
        if (this.isEvaluateNow()) {
            this.setBarcodeImage(image);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)image, this.barcodeComponent.getEvaluationTime(), this.barcodeComponent.getEvaluationGroup());
        }
        return image;
    }

    protected JRTemplateImage getTemplateImage() {
        JRStyle elementStyle = this.fillContext.getElementStyle();
        JRTemplateImage templateImage = this.printTemplates.get(elementStyle);
        if (templateImage == null) {
            templateImage = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            templateImage.setElement((JRElement)this.fillContext.getComponentElement());
            templateImage.setStyle(elementStyle);
            templateImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
            templateImage.setUsingCache(false);
            templateImage = (JRTemplateImage)this.deduplicate((Deduplicable)templateImage);
            this.printTemplates.put(elementStyle, templateImage);
        }
        return templateImage;
    }

    protected void setBarcodeImage(JRTemplatePrintImage image) {
        if (this.renderable != null) {
            image.setRenderer(this.renderable);
        }
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateBarcode(evaluation);
        this.setBarcodeImage((JRTemplatePrintImage)element);
    }
}

