/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barcode4j;

import net.sf.jasperreports.barcode4j.AbstractBarcodeEvaluator;
import net.sf.jasperreports.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.barcode4j.BarcodeComponent;
import net.sf.jasperreports.barcode4j.CodabarComponent;
import net.sf.jasperreports.barcode4j.Code128Component;
import net.sf.jasperreports.barcode4j.Code39Component;
import net.sf.jasperreports.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.barcode4j.EAN128Component;
import net.sf.jasperreports.barcode4j.EAN13Component;
import net.sf.jasperreports.barcode4j.EAN8Component;
import net.sf.jasperreports.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.barcode4j.PDF417Component;
import net.sf.jasperreports.barcode4j.POSTNETComponent;
import net.sf.jasperreports.barcode4j.QRCodeComponent;
import net.sf.jasperreports.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.barcode4j.UPCAComponent;
import net.sf.jasperreports.barcode4j.UPCEComponent;
import net.sf.jasperreports.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.Renderable;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;

public class BarcodeDesignEvaluator
extends AbstractBarcodeEvaluator {
    public BarcodeDesignEvaluator(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, JRDefaultStyleProvider defaultStyleProvider) {
        super(jasperReportsContext, componentElement, defaultStyleProvider);
    }

    public Renderable evaluateImage() {
        this.evaluateBarcode();
        return this.renderable;
    }

    protected void evaluateBaseBarcode(BarcodeComponent barcodeComponent, String defaultMessage) {
        this.message = this.evaluateStringExpression(barcodeComponent.getCodeExpression(), defaultMessage);
    }

    protected void evaluateBaseBarcode(Barcode4jComponent barcodeComponent, String defaultMessage) {
        this.evaluateBaseBarcode((BarcodeComponent)barcodeComponent, defaultMessage);
        String pattern = this.evaluateStringExpression(barcodeComponent.getPatternExpression(), null);
        if (pattern != null) {
            this.barcodeBean.setPattern(pattern);
        }
    }

    protected String evaluateStringExpression(JRExpression expression, String defaultValue) {
        String value = JRExpressionUtil.getSimpleExpressionText((JRExpression)expression);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    protected void evaluateCodabar(CodabarComponent codabar) {
        this.evaluateBaseBarcode(codabar, "0123456789");
    }

    @Override
    protected void evaluateCode128(Code128Component code128) {
        this.evaluateBaseBarcode(code128, "0123456789");
    }

    @Override
    protected void evaluateDataMatrix(DataMatrixComponent dataMatrix) {
        this.evaluateBaseBarcode(dataMatrix, "0123456789");
    }

    @Override
    protected void evaluateEANCode128(EAN128Component ean128) {
        this.evaluateBaseBarcode(ean128, "0101234567890128");
        String template = this.evaluateStringExpression(ean128.getTemplateExpression(), null);
        if (template != null) {
            ((EAN128Bean)this.barcodeBean).setTemplate(template);
        }
    }

    @Override
    protected void evaluateCode39(Code39Component code39) {
        this.evaluateBaseBarcode(code39, "01234567892");
    }

    @Override
    protected void evaluateUPCA(UPCAComponent upcA) {
        String checksumMode = upcA.getChecksumMode();
        String defaultMessage = checksumMode != null && checksumMode.equals(ChecksumMode.CP_ADD.getName()) ? "01234567890" : "012345678905";
        this.evaluateBaseBarcode(upcA, defaultMessage);
    }

    @Override
    protected void evaluateUPCE(UPCEComponent upcE) {
        String checksumMode = upcE.getChecksumMode();
        String defaultMessage = checksumMode != null && checksumMode.equals(ChecksumMode.CP_ADD.getName()) ? "0123413" : "01234133";
        this.evaluateBaseBarcode(upcE, defaultMessage);
    }

    @Override
    protected void evaluateEAN13(EAN13Component ean13) {
        String checksumMode = ean13.getChecksumMode();
        String defaultMessage = checksumMode != null && checksumMode.equals(ChecksumMode.CP_ADD.getName()) ? "012345678901" : "0123456789012";
        this.evaluateBaseBarcode(ean13, defaultMessage);
    }

    @Override
    protected void evaluateEAN8(EAN8Component ean8) {
        String checksumMode = ean8.getChecksumMode();
        String defaultMessage = checksumMode != null && checksumMode.equals(ChecksumMode.CP_ADD.getName()) ? "0123456" : "01234565";
        this.evaluateBaseBarcode(ean8, defaultMessage);
    }

    @Override
    protected void evaluateInterleaved2Of5(Interleaved2Of5Component interleaved2Of5) {
        this.evaluateBaseBarcode(interleaved2Of5, "0123456784");
    }

    @Override
    protected void evaluateRoyalMailCustomer(RoyalMailCustomerComponent royalMailCustomer) {
        String checksumMode = royalMailCustomer.getChecksumMode();
        String defaultMessage = checksumMode != null && checksumMode.equals(ChecksumMode.CP_CHECK.getName()) ? "01234Q" : "01234";
        this.evaluateBaseBarcode(royalMailCustomer, defaultMessage);
    }

    @Override
    protected void evaluateUSPSIntelligentMail(USPSIntelligentMailComponent intelligentMail) {
        this.evaluateBaseBarcode(intelligentMail, "00040123456200800001987654321");
    }

    @Override
    protected void evaluatePOSTNET(POSTNETComponent intelligentMail) {
        this.evaluateBaseBarcode(intelligentMail, "01234");
    }

    @Override
    protected void evaluatePDF417(PDF417Component pdf417) {
        this.evaluateBaseBarcode(pdf417, "01234");
    }

    @Override
    protected void evaluateQRCode(QRCodeComponent qrCode) {
        this.evaluateBaseBarcode(qrCode, "0123456789");
    }
}

