/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.service.EntityResourceFactoryV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/v2/agents/cacheManagers/configs")
public final class CacheManagerConfigsResourceServiceImplV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagerConfigsResourceServiceImplV2.class);
    private final EntityResourceFactoryV2 entityResourceFactory = (EntityResourceFactoryV2)ServiceLocator.locate(EntityResourceFactoryV2.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    @GET
    @Produces(value={"application/json"})
    public ResponseEntityV2 getCacheManagerConfigs(@Context UriInfo info) {
        LOG.debug(String.format("Invoking CacheManagerConfigsResourceServiceImpl.getXMLCacheManagerConfigs: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String names = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = names == null ? null : new HashSet<String>(Arrays.asList(names.split(",")));
        try {
            return this.entityResourceFactory.createCacheManagerConfigEntities(cmNames);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to get xml cache manager configs", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

