/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.CacheEntityV2;
import net.sf.ehcache.management.service.CacheServiceV2;
import net.sf.ehcache.management.service.EntityResourceFactoryV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/v2/agents/cacheManagers/caches")
public final class CachesResourceServiceImplV2 {
    public static final String ATTR_QUERY_KEY = "show";
    private static final Logger LOG = LoggerFactory.getLogger(CachesResourceServiceImplV2.class);
    private final EntityResourceFactoryV2 entityResourceFactory = (EntityResourceFactoryV2)ServiceLocator.locate(EntityResourceFactoryV2.class);
    private final CacheServiceV2 cacheSvc;
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    public CachesResourceServiceImplV2() {
        this.cacheSvc = (CacheServiceV2)ServiceLocator.locate(CacheServiceV2.class);
    }

    @GET
    @Produces(value={"application/json"})
    public ResponseEntityV2 getCaches(@Context UriInfo info) {
        LOG.debug(String.format("Invoking CachesResourceServiceImpl.getCaches: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String cacheManagerNames = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = cacheManagerNames == null ? null : new HashSet<String>(Arrays.asList(cacheManagerNames.split(",")));
        String cacheNames = (String)((PathSegment)info.getPathSegments().get(3)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cNames = cacheNames == null ? null : new HashSet<String>(Arrays.asList(cacheNames.split(",")));
        MultivaluedMap qParams = info.getQueryParameters();
        List attrs = (List)qParams.get((Object)ATTR_QUERY_KEY);
        HashSet<String> cAttrs = attrs == null || attrs.isEmpty() ? null : new HashSet<String>(attrs);
        try {
            return this.entityResourceFactory.createCacheEntities(cmNames, cNames, cAttrs);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to get caches", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public void createOrUpdateCache(@Context UriInfo info, CacheEntityV2 resource) {
        LOG.debug(String.format("Invoking CachesResourceServiceImpl.createOrUpdateCache: %s", info.getRequestUri()));
        this.validator.validate(info);
        String cacheManagerName = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        String cacheName = (String)((PathSegment)info.getPathSegments().get(3)).getMatrixParameters().getFirst((Object)"names");
        try {
            this.cacheSvc.createOrUpdateCache(cacheManagerName, cacheName, resource);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to create or update cache", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

