/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.scanner;

import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.spi.scanning.uri.BundleSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.FileSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.JarZipSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.VfsSchemeScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TerracottaPrivateClassScanner
implements UriSchemeScanner {
    private static final String PRIVATE_CLASS_SUFFIX = ".class_terracotta";
    private Map<String, UriSchemeScanner> scanners = new HashMap<String, UriSchemeScanner>();

    public TerracottaPrivateClassScanner() {
        this.inspect((UriSchemeScanner)new JarZipSchemeScanner());
        this.inspect((UriSchemeScanner)new FileSchemeScanner());
        this.inspect((UriSchemeScanner)new VfsSchemeScanner());
        this.inspect((UriSchemeScanner)new BundleSchemeScanner());
    }

    private void inspect(UriSchemeScanner scanner) {
        for (String scheme : scanner.getSchemes()) {
            this.scanners.put(scheme, scanner);
        }
    }

    public Set<String> getSchemes() {
        return this.scanners.keySet();
    }

    public void scan(URI u, ScannerListener sl) throws ScannerException {
        UriSchemeScanner scanner = this.scanners.get(u.getScheme());
        if (scanner == null) {
            throw new AssertionError();
        }
        scanner.scan(u, (ScannerListener)new ClazzScannerListener(sl));
    }

    private static class ClazzScannerListener
    implements ScannerListener {
        private final ScannerListener sl;

        ClazzScannerListener(ScannerListener sl) {
            this.sl = sl;
        }

        public boolean onAccept(String name) {
            if (name.endsWith(TerracottaPrivateClassScanner.PRIVATE_CLASS_SUFFIX)) {
                name = name.substring(0, name.lastIndexOf(TerracottaPrivateClassScanner.PRIVATE_CLASS_SUFFIX)).concat(".class");
            }
            return this.sl.onAccept(name);
        }

        public void onProcess(String name, InputStream in) throws IOException {
            this.sl.onProcess(name, in);
        }
    }
}

