/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.services.CachesResourceService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents/cacheManagers/caches")
public final class CachesResourceServiceImpl
implements CachesResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(CachesResourceServiceImpl.class);
    private final EntityResourceFactory entityResourceFactory = (EntityResourceFactory)ServiceLocator.locate(EntityResourceFactory.class);
    private final CacheService cacheSvc;
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    public CachesResourceServiceImpl() {
        this.cacheSvc = (CacheService)ServiceLocator.locate(CacheService.class);
    }

    public Collection<CacheEntity> getCaches(UriInfo info) {
        LOG.debug(String.format("Invoking CachesResourceServiceImpl.getCaches: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String cacheManagerNames = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = cacheManagerNames == null ? null : new HashSet<String>(Arrays.asList(cacheManagerNames.split(",")));
        String cacheNames = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cNames = cacheNames == null ? null : new HashSet<String>(Arrays.asList(cacheNames.split(",")));
        MultivaluedMap qParams = info.getQueryParameters();
        List attrs = (List)qParams.get((Object)"show");
        HashSet<String> cAttrs = attrs == null || attrs.isEmpty() ? null : new HashSet<String>(attrs);
        try {
            return this.entityResourceFactory.createCacheEntities(cmNames, cNames, cAttrs);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to get caches", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    public void createOrUpdateCache(UriInfo info, CacheEntity resource) {
        LOG.debug(String.format("Invoking CachesResourceServiceImpl.createOrUpdateCache: %s", info.getRequestUri()));
        this.validator.validate(info);
        String cacheManagerName = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        String cacheName = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        try {
            this.cacheSvc.createOrUpdateCache(cacheManagerName, cacheName, resource);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to create or update cache", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    public void deleteCache(UriInfo info) {
        LOG.debug(String.format("Invoking CachesResourceServiceImpl.deleteCache: %s", info.getRequestUri()));
        throw new ResourceRuntimeException("Not yet implemented", Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    }
}

