/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.ehcache.management.resource.CacheManagerConfigEntity;
import net.sf.ehcache.management.sampled.CacheManagerSampler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class CacheManagerConfigurationEntityBuilder {
    private final List<CacheManagerSampler> cmSamplers = new ArrayList<CacheManagerSampler>();

    static CacheManagerConfigurationEntityBuilder createWith(CacheManagerSampler sampler) {
        return new CacheManagerConfigurationEntityBuilder(sampler);
    }

    private CacheManagerConfigurationEntityBuilder(CacheManagerSampler sampler) {
        this.addSampler(sampler);
    }

    CacheManagerConfigurationEntityBuilder add(CacheManagerSampler sampler) {
        this.addSampler(sampler);
        return this;
    }

    Collection<CacheManagerConfigEntity> build() {
        ArrayList<CacheManagerConfigEntity> cmces = new ArrayList<CacheManagerConfigEntity>(this.cmSamplers.size());
        DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = domFact.newDocumentBuilder();
            for (CacheManagerSampler sampler : this.cmSamplers) {
                Document config;
                CacheManagerConfigEntity cmce = new CacheManagerConfigEntity();
                cmce.setCacheManagerName(sampler.getName());
                cmce.setAgentId("embedded");
                cmce.setVersion(this.getClass().getPackage().getImplementationVersion());
                String xml = sampler.generateActiveConfigDeclaration();
                try {
                    config = domBuilder.parse(new InputSource(new StringReader(xml)));
                }
                catch (SAXException e) {
                    throw new RuntimeException(String.format("Failed to parse cache manager configuration xml for \"%s\".", sampler.getName()), e);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to serialize cache manager configuration for \"%s\".", sampler.getName()), e);
                }
                cmce.setXml(config.getDocumentElement());
                cmces.add(cmce);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to instantiate DocumentBuilder for parsing cache manager configurations", e);
        }
        return cmces;
    }

    private void addSampler(CacheManagerSampler sampler) {
        if (sampler == null) {
            throw new IllegalArgumentException("sampler == null");
        }
        this.cmSamplers.add(sampler);
    }
}

