/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.AbstractManagementServer;
import net.sf.ehcache.management.resource.services.validator.impl.EmbeddedEhcacheRequestValidator;
import net.sf.ehcache.management.service.AgentService;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryService;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.embedded.FilterDetail;
import org.terracotta.management.embedded.NoIaFilter;
import org.terracotta.management.embedded.StandaloneServer;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.LicenseServiceImpl;
import org.terracotta.management.resource.services.validator.RequestValidator;

public final class ManagementServerImpl
extends AbstractManagementServer {
    public ManagementServerImpl(String clientUUID, ManagementRESTServiceConfiguration configuration) {
        configuration.setNeedClientAuth(false);
        configuration.setSecurityServiceLocation(null);
        configuration.setSslEnabled(false);
        configuration.setSecurityServiceTimeout(0);
        String basePackage = "net.sf.ehcache.management";
        String host = configuration.getHost();
        int port = configuration.getPort();
        this.loadEmbeddedAgentServiceLocator(clientUUID, configuration);
        this.samplerRepoSvc = (SamplerRepositoryService)ServiceLocator.locate(SamplerRepositoryService.class);
        List<FilterDetail> filterDetails = Collections.singletonList(new FilterDetail((Filter)new NoIaFilter(), "/*"));
        this.standaloneServer = new StandaloneServer(filterDetails, null, basePackage, host, port, null, false);
    }

    private void loadEmbeddedAgentServiceLocator(String clientUUID, ManagementRESTServiceConfiguration configuration) {
        DfltSamplerRepositoryService samplerRepoSvc = new DfltSamplerRepositoryService(clientUUID, configuration);
        LicenseServiceImpl licenseService = new LicenseServiceImpl(false);
        ServiceLocator locator = new ServiceLocator().loadService(LicenseService.class, (Object)licenseService).loadService(RequestValidator.class, (Object)new EmbeddedEhcacheRequestValidator()).loadService(CacheManagerService.class, (Object)samplerRepoSvc).loadService(CacheService.class, (Object)samplerRepoSvc).loadService(EntityResourceFactory.class, (Object)samplerRepoSvc).loadService(SamplerRepositoryService.class, (Object)samplerRepoSvc).loadService(AgentService.class, (Object)samplerRepoSvc).loadService(ManagementRESTServiceConfiguration.class, (Object)configuration);
        ServiceLocator.load((ServiceLocator)locator);
    }
}

