/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.Path;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.CacheConfigEntity;
import net.sf.ehcache.management.resource.ConfigContainerEntity;
import net.sf.ehcache.management.resource.services.CacheConfigsResourceService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents/cacheManagers/caches/configs")
public final class CacheConfigsResourceServiceImpl
implements CacheConfigsResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConfigsResourceServiceImpl.class);
    private final EntityResourceFactory entityResourceFactory = (EntityResourceFactory)ServiceLocator.locate(EntityResourceFactory.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    public Response getXMLCacheConfigs(UriInfo info) {
        LOG.debug(String.format("Invoking CacheConfigsResourceServiceImpl.getXMLCacheConfigs: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String cacheManagerNames = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = cacheManagerNames == null ? null : new HashSet<String>(Arrays.asList(cacheManagerNames.split(",")));
        String cacheNames = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cNames = cacheNames == null ? null : new HashSet<String>(Arrays.asList(cacheNames.split(",")));
        try {
            Collection<CacheConfigEntity> configs = this.entityResourceFactory.createCacheConfigEntities(cmNames, cNames);
            ConfigContainerEntity cc = new ConfigContainerEntity();
            cc.setConfiguration(configs);
            cc.setAgentId("embedded");
            return Response.ok((Object)cc).build();
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to get xml cache configs", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

