/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.management.resource.CacheConfigEntity;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.CacheManagerConfigEntity;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import net.sf.ehcache.management.sampled.CacheManagerSampler;
import net.sf.ehcache.management.sampled.CacheManagerSamplerImpl;
import net.sf.ehcache.management.sampled.ComprehensiveCacheSampler;
import net.sf.ehcache.management.sampled.ComprehensiveCacheSamplerImpl;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.CacheConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheStatisticSampleEntityBuilder;
import org.terracotta.management.ServiceExecutionException;

public final class DfltSamplerRepositoryService
implements SamplerRepositoryService,
EntityResourceFactory,
CacheManagerService,
CacheService {
    private final Map<String, SamplerRepoEntry> cacheManagerSamplerRepo = new HashMap<String, SamplerRepoEntry>();
    private final ReadWriteLock cacheManagerSamplerRepoLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(CacheManager cacheManager) {
        String cmName = cacheManager.getName();
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            if (!this.cacheManagerSamplerRepo.containsKey(cmName)) {
                SamplerRepoEntry entry = new SamplerRepoEntry(cacheManager);
                cacheManager.setCacheManagerEventListener((CacheManagerEventListener)entry);
                this.cacheManagerSamplerRepo.put(cmName, entry);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(CacheManager cacheManager) {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.remove(cacheManager.getName());
            entry.destroy();
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRegistered() {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            boolean bl = !this.cacheManagerSamplerRepo.isEmpty();
            return bl;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheManagerEntity> createCacheManagerEntities(Set<String> cacheManagerNames, Set<String> attributes) {
        Collection<Object> entities;
        CacheManagerEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheManagerConfigEntity> createCacheManagerConfigEntities(Set<String> cacheManagerNames) {
        Collection<CacheManagerConfigEntity> entities;
        CacheManagerConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet<CacheManagerConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheEntity> createCacheEntities(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> attributes) {
        Collection<Object> entities;
        CacheEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry<String, SamplerRepoEntry> entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : entry.getValue().getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith(sampler, entry.getKey()) : builder.add(sampler, entry.getKey());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith(sampler, cmName) : builder.add(sampler, cmName);
                    }
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheConfigEntity> createCacheConfigEntities(Set<String> cacheManagerNames, Set<String> cacheNames) {
        Collection<CacheConfigEntity> entities;
        CacheConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry<String, SamplerRepoEntry> entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : entry.getValue().getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith(entry.getValue().getCacheManagerSampler(), sampler.getCacheName()) : builder.add(entry.getValue().getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler(), sampler.getCacheName()) : builder.add(entry.getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            }
            entities = builder == null ? new HashSet<CacheConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheStatisticSampleEntity> createCacheStatisticSampleEntity(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> sampleNames) {
        CacheStatisticSampleEntityBuilder builder = CacheStatisticSampleEntityBuilder.createWith(sampleNames);
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (ComprehensiveCacheSampler sampler : ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, (String)entry.getKey());
                    }
                }
            } else {
                for (String string : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(string);
                    if (entry == null) continue;
                    for (ComprehensiveCacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, string);
                    }
                }
            }
            Collection<CacheStatisticSampleEntity> collection = builder.build();
            return collection;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCacheStats(String cacheManagerName, String cacheName) {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                entry.clearStats(cacheName);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdateCache(String cacheManagerName, String cacheName, CacheEntity resource) throws ServiceExecutionException {
        block4: {
            this.cacheManagerSamplerRepoLock.readLock().lock();
            try {
                SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
                if (entry != null) {
                    entry.updateCache(cacheName, resource);
                    break block4;
                }
                throw new UnsupportedOperationException("Create cache not implemented!");
            }
            finally {
                this.cacheManagerSamplerRepoLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String cacheManagerName, String cacheName) {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                entry.clearCache(cacheName);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheManager(String cacheManagerName, CacheManagerEntity resource) throws ServiceExecutionException {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                Object mblhsAttr;
                Object mbldsAttr;
                Object mblhAttr;
                CacheManagerSampler cms = entry.getCacheManagerSampler();
                Object mbldAttr = resource.getAttributes().get("MaxBytesLocalDisk");
                if (mbldAttr != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mbldAttr.toString()));
                }
                if ((mblhAttr = resource.getAttributes().get("MaxBytesLocalHeap")) != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mblhAttr.toString()));
                }
                if ((mbldsAttr = resource.getAttributes().get("MaxBytesLocalDiskAsString")) != null) {
                    cms.setMaxBytesLocalDiskAsString(mbldsAttr.toString());
                }
                if ((mblhsAttr = resource.getAttributes().get("MaxBytesLocalHeapAsString")) != null) {
                    cms.setMaxBytesLocalHeapAsString(mblhsAttr.toString());
                }
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    private static final class SamplerRepoEntry
    implements CacheManagerEventListener {
        private static final String ENABLED_ATTR = "Enabled";
        private static final String STATS_ENABLED_ATTR = "StatisticsEnabled";
        private static final String SAMPLED_STATS_ENABLED_ATTR = "SampledStatisticsEnabled";
        private static final String BULK_LOAD_ENABLED = "ClusterBulkLoadEnabled";
        private static final String MAX_ELEMENTS_ON_DISK = "MaxElementsOnDisk";
        private static final String MAX_BYTES_LOCAL_DISK = "MaxBytesLocalDisk";
        private static final String MAX_BYTES_LOCAL_DISK_STRING = "MaxBytesLocalDiskAsString";
        private static final String MAX_BYTES_LOCAL_HEAP = "MaxBytesLocalHeap";
        private static final String MAX_BYTES_LOCAL_HEAP_STRING = "MaxBytesLocalHeapAsString";
        private static final String LOGGING_ENABLED = "LoggingEnabled";
        private static final String TIME_TO_IDLE_SEC = "TimeToIdleSeconds";
        private static final String TIME_TO_LIVE_SEC = "TimeToLiveSeconds";
        private static final String MAX_ENTRIES_LOCAL_HEAP = "MaxEntriesLocalHeap";
        private CacheManager cacheManager;
        private CacheManagerSampler cacheManagerSampler;
        private Map<String, ComprehensiveCacheSampler> cacheSamplersByName;
        private volatile Status status = Status.STATUS_UNINITIALISED;
        private final ReadWriteLock cacheSamplerMapLock = new ReentrantReadWriteLock();

        public SamplerRepoEntry(CacheManager cacheManager) {
            if (cacheManager == null) {
                throw new IllegalArgumentException("cacheManager == null");
            }
            this.cacheManagerSampler = new CacheManagerSamplerImpl(cacheManager);
            this.cacheManager = cacheManager;
            String[] cNames = cacheManager.getCacheNames();
            this.cacheSamplersByName = new HashMap<String, ComprehensiveCacheSampler>(cNames.length);
            for (String cName : cNames) {
                this.cacheSamplersByName.put(cName, (ComprehensiveCacheSampler)new ComprehensiveCacheSamplerImpl(cacheManager.getCache(cName)));
            }
        }

        public CacheManagerSampler getCacheManagerSampler() {
            return this.cacheManagerSampler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ComprehensiveCacheSampler> getComprehensiveCacheSamplers(Set<String> cacheSamplerNames) {
            HashSet<ComprehensiveCacheSampler> samplers = new HashSet<ComprehensiveCacheSampler>();
            this.cacheSamplerMapLock.readLock().lock();
            try {
                if (cacheSamplerNames == null) {
                    for (ComprehensiveCacheSampler cs : this.cacheSamplersByName.values()) {
                        samplers.add(cs);
                    }
                } else {
                    for (String cName : cacheSamplerNames) {
                        ComprehensiveCacheSampler cs = this.cacheSamplersByName.get(cName);
                        if (cs == null) continue;
                        samplers.add(cs);
                    }
                }
            }
            finally {
                this.cacheSamplerMapLock.readLock().unlock();
            }
            return samplers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearStats(String cacheSamplerName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                ComprehensiveCacheSampler cs = this.cacheSamplersByName.get(cacheSamplerName);
                if (cs != null) {
                    cs.clearStatistics();
                }
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache(String cacheSamplerName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                ComprehensiveCacheSampler cs = this.cacheSamplersByName.get(cacheSamplerName);
                if (cs != null) {
                    cs.removeAll();
                }
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(String cacheSamplerName, CacheEntity cacheResource) throws ServiceExecutionException {
            block20: {
                this.cacheSamplerMapLock.writeLock().lock();
                try {
                    ComprehensiveCacheSampler cs = this.cacheSamplersByName.get(cacheSamplerName);
                    if (cs == null) break block20;
                    try {
                        Object ttlAttr;
                        Object ttiAttr;
                        Integer melhAttr;
                        Object mblhsAttr;
                        Object mblhAttr;
                        Object mbldsAttr;
                        Object mbldAttr;
                        Boolean loggingEnabledAttr;
                        Integer maxElementsOnDiskAttr;
                        Boolean enabledSampledStatsAttr;
                        Boolean enabledStatsAttr;
                        Boolean enabledBlkLoad;
                        Boolean enabledAttr = (Boolean)cacheResource.getAttributes().get(ENABLED_ATTR);
                        if (enabledAttr != null) {
                            cs.setEnabled(enabledAttr.booleanValue());
                        }
                        if ((enabledBlkLoad = (Boolean)cacheResource.getAttributes().get(BULK_LOAD_ENABLED)) != null) {
                            cs.setNodeBulkLoadEnabled(enabledBlkLoad.booleanValue());
                        }
                        if ((enabledStatsAttr = (Boolean)cacheResource.getAttributes().get(STATS_ENABLED_ATTR)) != null) {
                            cs.setStatisticsEnabled(enabledStatsAttr.booleanValue());
                        }
                        if ((enabledSampledStatsAttr = (Boolean)cacheResource.getAttributes().get(SAMPLED_STATS_ENABLED_ATTR)) != null) {
                            if (enabledSampledStatsAttr.booleanValue()) {
                                cs.enableSampledStatistics();
                            } else {
                                cs.disableSampledStatistics();
                            }
                        }
                        if ((maxElementsOnDiskAttr = (Integer)cacheResource.getAttributes().get(MAX_ELEMENTS_ON_DISK)) != null) {
                            cs.setMaxElementsOnDisk(maxElementsOnDiskAttr.intValue());
                        }
                        if ((loggingEnabledAttr = (Boolean)cacheResource.getAttributes().get(LOGGING_ENABLED)) != null) {
                            cs.setLoggingEnabled(loggingEnabledAttr.booleanValue());
                        }
                        if ((mbldAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_DISK)) != null) {
                            cs.setMaxBytesLocalDisk(Long.parseLong(mbldAttr.toString()));
                        }
                        if ((mbldsAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_DISK_STRING)) != null) {
                            cs.setMaxBytesLocalDiskAsString(mbldsAttr.toString());
                        }
                        if ((mblhAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_HEAP)) != null) {
                            cs.setMaxBytesLocalDisk(Long.parseLong(mblhAttr.toString()));
                        }
                        if ((mblhsAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_HEAP_STRING)) != null) {
                            cs.setMaxBytesLocalHeapAsString(mblhsAttr.toString());
                        }
                        if ((melhAttr = (Integer)cacheResource.getAttributes().get(MAX_ENTRIES_LOCAL_HEAP)) != null) {
                            cs.setMaxEntriesLocalHeap((long)melhAttr.intValue());
                        }
                        if ((ttiAttr = cacheResource.getAttributes().get(TIME_TO_IDLE_SEC)) != null) {
                            cs.setTimeToIdleSeconds(Long.parseLong(ttiAttr.toString()));
                        }
                        if ((ttlAttr = cacheResource.getAttributes().get(TIME_TO_LIVE_SEC)) != null) {
                            cs.setTimeToLiveSeconds(Long.parseLong(ttlAttr.toString()));
                        }
                    }
                    catch (RuntimeException e) {
                        throw new ServiceExecutionException((Throwable)e);
                    }
                }
                finally {
                    this.cacheSamplerMapLock.writeLock().unlock();
                }
            }
        }

        public void init() throws CacheException {
            this.status = Status.STATUS_ALIVE;
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() throws CacheException {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                this.cacheSamplersByName.clear();
                this.cacheSamplersByName = null;
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
            this.status = Status.STATUS_SHUTDOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCacheAdded(String cacheName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                Cache c = this.cacheManager.getCache(cacheName);
                if (c != null) {
                    this.cacheSamplersByName.put(cacheName, (ComprehensiveCacheSampler)new ComprehensiveCacheSamplerImpl(c));
                }
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCacheRemoved(String cacheName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                this.cacheSamplersByName.remove(cacheName);
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        public void destroy() {
            this.cacheManagerSampler = null;
            this.cacheManager = null;
        }
    }
}

