/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.jmx.CacheJmxClient;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.services.CachesResourceService;

@Path(value="/agents/tsa/cacheManagers/caches")
public class ClusteredCachesResourceServiceImpl
implements CachesResourceService {
    private static final List<String> EXCLUDED_ATTRIBUTES = Arrays.asList("CacheName");

    public Collection<CacheEntity> getCaches(UriInfo info) {
        List<String> cacheManagerNames;
        String ids = (String)((PathSegment)info.getPathSegments().get(0)).getMatrixParameters().getFirst((Object)"ids");
        if (ids != null && !"embedded".equals(ids)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Agent ID must be '%s'.", "embedded")).build());
        }
        String cacheManagerNamesString = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        if (cacheManagerNamesString == null) {
            cacheManagerNames = null;
        } else {
            String[] names = cacheManagerNamesString.split("\\,");
            cacheManagerNames = Arrays.asList(names);
        }
        try {
            ArrayList<CacheEntity> result = new ArrayList<CacheEntity>();
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            Map<String, Map<String, ObjectName>> allCacheObjectNamesByCacheNameByCacheManagerName = CacheJmxClient.getAllCacheObjectNamesByCacheNameByCacheManagerName(platformMBeanServer, cacheManagerNames);
            String cacheNamesString = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
            MultivaluedMap qParams = info.getQueryParameters();
            if (cacheNamesString == null) {
                for (Map.Entry<String, Map<String, ObjectName>> cacheManagerEntry : allCacheObjectNamesByCacheNameByCacheManagerName.entrySet()) {
                    for (Map.Entry<String, ObjectName> cacheEntry : cacheManagerEntry.getValue().entrySet()) {
                        result.add(this.buildEntity(platformMBeanServer, cacheManagerEntry.getKey(), cacheEntry.getValue(), (MultivaluedMap<String, String>)qParams));
                    }
                }
            } else {
                String[] cacheNames;
                for (String cacheName : cacheNames = cacheNamesString.split("\\,")) {
                    boolean found = false;
                    for (Map.Entry<String, Map<String, ObjectName>> cacheManagerEntry : allCacheObjectNamesByCacheNameByCacheManagerName.entrySet()) {
                        ObjectName objectName = cacheManagerEntry.getValue().get(cacheName);
                        if (objectName == null) continue;
                        found = true;
                        String cacheManagerName = cacheManagerEntry.getKey();
                        result.add(this.buildEntity(platformMBeanServer, cacheManagerName, objectName, (MultivaluedMap<String, String>)qParams));
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("unknown cache with name [" + cacheName + "]");
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build());
        }
    }

    private CacheEntity buildEntity(MBeanServer platformMBeanServer, String cacheManagerName, ObjectName objectName, MultivaluedMap<String, String> qParams) throws InstanceNotFoundException, IntrospectionException, ReflectionException, MBeanException, AttributeNotFoundException {
        MBeanAttributeInfo[] attributes;
        CacheEntity e = new CacheEntity();
        e.setAgentId("embedded");
        e.setCacheManagerName(cacheManagerName);
        String cacheName = (String)platformMBeanServer.getAttribute(objectName, "CacheName");
        e.setName(cacheName);
        for (MBeanAttributeInfo attribute : attributes = platformMBeanServer.getMBeanInfo(objectName).getAttributes()) {
            String attrName = attribute.getName();
            if (EXCLUDED_ATTRIBUTES.contains(attrName) || qParams != null && qParams.get((Object)"show") != null && !((List)qParams.get((Object)"show")).contains(attrName)) continue;
            Object attrValue = platformMBeanServer.getAttribute(objectName, attrName);
            e.getAttributes().put(attrName, attrValue);
        }
        return e;
    }

    public void createOrUpdateCache(UriInfo info, CacheEntity resource) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Not yet implemented").build());
    }

    public void deleteCache(UriInfo info) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Not yet implemented").build());
    }

    public void wipeStatistics(@Context UriInfo info) {
    }
}

