/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import com.terracotta.management.security.IACredentials;
import com.terracotta.management.security.IdentityAssertionServiceClient;
import com.terracotta.management.security.impl.ContextSecurityServiceDirectory;
import com.terracotta.management.security.shiro.IdentityAssertionToken;
import com.terracotta.management.security.shiro.realm.TCIdentityAssertionRealm;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.service.impl.RemoteAgentEndpointImpl;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.l1bridge.RemoteCallDescriptor;

public class RemoteAgentEndpointImplEE
extends RemoteAgentEndpointImpl {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAgentEndpointImplEE.class);
    public static final String MBEAN_NAME_PREFIX = "net.sf.ehcache:type=" + IDENTIFIER;
    private final ManagementRESTServiceConfiguration configuration;
    private final IdentityAssertionServiceClient idAssertionSvcClient;
    private final ContextSecurityServiceDirectory contextSecurityServiceDirectory;
    private volatile boolean securityManagerInitialized = false;
    private final Object securityManagerInitializationLock = new Object();
    private final ThreadLocal<Boolean> tsaSecured = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public RemoteAgentEndpointImplEE(ManagementRESTServiceConfiguration configuration, IdentityAssertionServiceClient idAssertionSvcClient, ContextSecurityServiceDirectory contextSecurityServiceDirectory) {
        this.configuration = configuration;
        this.idAssertionSvcClient = idAssertionSvcClient;
        this.contextSecurityServiceDirectory = contextSecurityServiceDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSecurityManager() {
        if (!this.securityManagerInitialized) {
            Object object = this.securityManagerInitializationLock;
            synchronized (object) {
                if (!this.securityManagerInitialized) {
                    try {
                        TCIdentityAssertionRealm realm = new TCIdentityAssertionRealm(this.idAssertionSvcClient);
                        DefaultSecurityManager securityManager = new DefaultSecurityManager((Realm)realm);
                        DefaultSubjectDAO sessionDAO = (DefaultSubjectDAO)securityManager.getSubjectDAO();
                        DefaultSessionStorageEvaluator sessionStorageEvaluator = (DefaultSessionStorageEvaluator)sessionDAO.getSessionStorageEvaluator();
                        sessionStorageEvaluator.setSessionStorageEnabled(false);
                        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    this.securityManagerInitialized = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invoke(RemoteCallDescriptor remoteCallDescriptor) throws Exception {
        Subject subject = null;
        if (remoteCallDescriptor.getIaCallbackUrl() != null && !Boolean.getBoolean("com.terracotta.management.debug.noIA")) {
            try {
                this.assertIaCallbackUrlInWhitelist(remoteCallDescriptor.getIaCallbackUrl());
                if (this.contextSecurityServiceDirectory != null) {
                    this.contextSecurityServiceDirectory.setSecurityServiceLocation(new URI(remoteCallDescriptor.getIaCallbackUrl()));
                }
                this.initSecurityManager();
                subject = SecurityUtils.getSubject();
                IACredentials iaCredentials = new IACredentials();
                iaCredentials.setRequestTicket(remoteCallDescriptor.getTicket());
                iaCredentials.setIdentityToken(remoteCallDescriptor.getToken());
                iaCredentials.setRequestAlias("jmx:" + MBEAN_NAME_PREFIX);
                IdentityAssertionToken identityAssertionToken = new IdentityAssertionToken(iaCredentials);
                subject.login((AuthenticationToken)identityAssertionToken);
                this.tsaSecured.set(true);
            }
            catch (AuthenticationException e) {
                LOG.warn("IA failed", (Throwable)e);
                throw new RuntimeException("IA failed: " + e);
            }
            catch (URISyntaxException e) {
                LOG.warn("IA failed because of invalid IA callback url [" + remoteCallDescriptor.getIaCallbackUrl() + "]", (Throwable)e);
                throw new RuntimeException("IA failed because of invalid IA callback url [" + remoteCallDescriptor.getIaCallbackUrl() + "]: " + e);
            }
            finally {
                if (this.contextSecurityServiceDirectory != null) {
                    this.contextSecurityServiceDirectory.clearSecurityServiceLocation();
                }
            }
        }
        try {
            byte[] byArray = super.invoke(remoteCallDescriptor);
            return byArray;
        }
        finally {
            if (subject != null && subject.isAuthenticated()) {
                subject.logout();
            }
            this.tsaSecured.set(false);
        }
    }

    protected boolean isTsaSecured() {
        return this.tsaSecured.get();
    }

    private void assertIaCallbackUrlInWhitelist(String iaCallbackUrl) {
        String[] locations;
        String securityServiceLocation = this.configuration.getSecurityServiceLocation();
        if (securityServiceLocation == null || securityServiceLocation.trim().equals("")) {
            return;
        }
        for (String location : locations = securityServiceLocation.split("\\,")) {
            if (!location.equals(iaCallbackUrl)) continue;
            return;
        }
        throw new RuntimeException("Identity Assertion callback URL [" + iaCallbackUrl + "] is not in this agent's configured whitelist. Please add it to the <managementRESTService securityServiceLocation=\"...\"/> configuration setting.");
    }
}

