
package org.glassfish.jersey.message.filtering.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.message.filtering.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableMERGING_FILTERING_SCOPES() {
        return MESSAGE_FACTORY.getMessage("merging.filtering.scopes");
    }

    /**
     * Merging two sets of entity-filtering scopes obtained from two different scope resolvers.
     * 
     */
    public static String MERGING_FILTERING_SCOPES() {
        return LOCALIZER.localize(localizableMERGING_FILTERING_SCOPES());
    }

    public static Localizable localizableENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(Object arg0) {
        return MESSAGE_FACTORY.getMessage("entity.filtering.scope.not.annotations", arg0);
    }

    /**
     * The entity-filtering scope property does not contain an instance of Annotation or Annotation[] ({0}).
     * 
     */
    public static String ENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(Object arg0) {
        return LOCALIZER.localize(localizableENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
