/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.shaded.lucene.index.AtomicReader;
import org.terracotta.shaded.lucene.index.CompositeReader;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.Fields;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.MultiDocValues;
import org.terracotta.shaded.lucene.index.MultiFields;
import org.terracotta.shaded.lucene.index.StoredFieldVisitor;
import org.terracotta.shaded.lucene.util.Bits;

public final class SlowCompositeReaderWrapper
extends AtomicReader {
    private final CompositeReader in;
    private final Map<String, DocValues> normsCache = new HashMap<String, DocValues>();
    private final Fields fields;
    private final Bits liveDocs;

    public static AtomicReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader);
        }
        assert (reader instanceof AtomicReader);
        return (AtomicReader)reader;
    }

    public SlowCompositeReaderWrapper(CompositeReader reader) throws IOException {
        this.in = reader;
        this.fields = MultiFields.getFields(this.in);
        this.liveDocs = MultiFields.getLiveDocs(this.in);
        this.in.registerParentReader(this);
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    @Override
    public Fields fields() {
        this.ensureOpen();
        return this.fields;
    }

    @Override
    public DocValues docValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getDocValues(this.in, field);
    }

    @Override
    public synchronized DocValues normValues(String field) throws IOException {
        this.ensureOpen();
        DocValues values = this.normsCache.get(field);
        if (values == null) {
            values = MultiDocValues.getNormDocValues(this.in, field);
            this.normsCache.put(field, values);
        }
        return values;
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.getTermVectors(docID);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return MultiFields.getMergedFieldInfos(this.in);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.liveDocs != null;
    }

    @Override
    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }
}

