/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.terracotta.shaded.lucene.codecs.PerDocProducerBase;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Bytes;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Floats;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Ints;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.index.SegmentReadState;
import org.terracotta.shaded.lucene.store.CompoundFileDirectory;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.IOUtils;

public class Lucene40DocValuesProducer
extends PerDocProducerBase {
    protected final TreeMap<String, DocValues> docValues;
    private final Directory cfs;

    public Lucene40DocValuesProducer(SegmentReadState state, String segmentSuffix) throws IOException {
        if (this.anyDocValuesFields(state.fieldInfos)) {
            this.cfs = new CompoundFileDirectory(state.dir, IndexFileNames.segmentFileName(state.segmentInfo.name, segmentSuffix, "cfs"), state.context, false);
            this.docValues = this.load(state.fieldInfos, state.segmentInfo.name, state.segmentInfo.getDocCount(), this.cfs, state.context);
        } else {
            this.cfs = null;
            this.docValues = new TreeMap();
        }
    }

    @Override
    protected Map<String, DocValues> docValues() {
        return this.docValues;
    }

    @Override
    protected void closeInternal(Collection<? extends Closeable> closeables) throws IOException {
        if (this.cfs != null) {
            ArrayList<? extends Closeable> list = new ArrayList<Closeable>(closeables);
            list.add(this.cfs);
            IOUtils.close(list);
        } else {
            IOUtils.close(closeables);
        }
    }

    @Override
    protected DocValues loadDocValues(int docCount, Directory dir, String id, DocValues.Type type, IOContext context) throws IOException {
        switch (type) {
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case FIXED_INTS_8: 
            case VAR_INTS: {
                return Ints.getValues(dir, id, docCount, type, context);
            }
            case FLOAT_32: {
                return Floats.getValues(dir, id, docCount, context, type);
            }
            case FLOAT_64: {
                return Floats.getValues(dir, id, docCount, context, type);
            }
            case BYTES_FIXED_STRAIGHT: {
                return Bytes.getValues(dir, id, Bytes.Mode.STRAIGHT, true, docCount, this.getComparator(), context);
            }
            case BYTES_FIXED_DEREF: {
                return Bytes.getValues(dir, id, Bytes.Mode.DEREF, true, docCount, this.getComparator(), context);
            }
            case BYTES_FIXED_SORTED: {
                return Bytes.getValues(dir, id, Bytes.Mode.SORTED, true, docCount, this.getComparator(), context);
            }
            case BYTES_VAR_STRAIGHT: {
                return Bytes.getValues(dir, id, Bytes.Mode.STRAIGHT, false, docCount, this.getComparator(), context);
            }
            case BYTES_VAR_DEREF: {
                return Bytes.getValues(dir, id, Bytes.Mode.DEREF, false, docCount, this.getComparator(), context);
            }
            case BYTES_VAR_SORTED: {
                return Bytes.getValues(dir, id, Bytes.Mode.SORTED, false, docCount, this.getComparator(), context);
            }
        }
        throw new IllegalStateException("unrecognized index values mode " + (Object)((Object)type));
    }
}

