/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.terracotta.license.EnterpriseLicense;
import org.terracotta.license.License;
import org.terracotta.license.LicenseConstants;
import org.terracotta.license.LicenseException;
import org.terracotta.license.LicenseSigner;
import org.terracotta.license.constraints.LicenseConstraint;
import org.terracotta.license.constraints.LicenseContraintsFactory;
import org.terracotta.license.util.MemorySizeParser;
import org.terracotta.license.util.Utils;

public class LicenseBuilder {
    private final Properties properties = new Properties();
    private InputStream privateKeyInputStream;

    public LicenseBuilder setProduct(String product) {
        this.properties.setProperty("Product", product);
        return this;
    }

    public LicenseBuilder setEdition(String edition) {
        this.properties.setProperty("Edition", edition);
        return this;
    }

    public LicenseBuilder setLicenseType(String type) {
        this.properties.setProperty("License Type", type);
        return this;
    }

    public LicenseBuilder setLicenseNumber(String number) {
        this.properties.setProperty("License Number", number);
        return this;
    }

    public LicenseBuilder setLicensee(String licensee) {
        this.properties.setProperty("Licensee", licensee);
        return this;
    }

    public LicenseBuilder setEmail(String email) {
        this.properties.setProperty("Email", email);
        return this;
    }

    public LicenseBuilder setCapabilities(String commaSeparatedCabapilities) {
        this.properties.setProperty("Capabilities", commaSeparatedCabapilities);
        return this;
    }

    public LicenseBuilder setCapabilities(Collection<String> capabilities) {
        this.properties.setProperty("Capabilities", Utils.join(capabilities, ", "));
        return this;
    }

    public LicenseBuilder setEhcacheMaxOffheap(String maxSize) {
        MemorySizeParser.parse(maxSize);
        this.properties.setProperty("ehcache.maxOffHeap", maxSize);
        return this;
    }

    public LicenseBuilder setTerracottaServerArrayMaxOffheap(String maxSize) {
        MemorySizeParser.parse(maxSize);
        this.properties.setProperty("terracotta.serverArray.maxOffHeap", maxSize);
        return this;
    }

    public LicenseBuilder setMaxClientCount(int maxClientCount) {
        this.properties.setProperty("Max Client Count", String.valueOf(maxClientCount));
        return this;
    }

    public LicenseBuilder setExpirationDate(String date) {
        try {
            LicenseConstants.dateFormatter().parse(date);
        }
        catch (ParseException e) {
            throw new LicenseException("Date format should be: " + "yyyy-MM-dd".toUpperCase());
        }
        this.properties.setProperty("Expiration Date", date);
        return this;
    }

    public LicenseBuilder setExpirationDate(Date date) {
        this.properties.setProperty("Expiration Date", LicenseConstants.dateFormatter().format(date));
        return this;
    }

    public LicenseBuilder setPrivateKeyInputStream(InputStream privateKeyInputStream) {
        this.privateKeyInputStream = privateKeyInputStream;
        return this;
    }

    public LicenseBuilder addProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public LicenseBuilder addProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
        return this;
    }

    public License createUnsignedLicense() {
        this.properties.setProperty("Date of Issue", LicenseConstants.dateFormatter().format(new Date()));
        this.properties.setProperty("Signature", "unsigned");
        EnterpriseLicense license = new EnterpriseLicense(this.properties);
        this.validateConstraints(license);
        return license;
    }

    public License createLicense() {
        this.properties.setProperty("Date of Issue", LicenseConstants.dateFormatter().format(new Date()));
        try {
            byte[] licenseBytes = Utils.toBytes(this.properties, LicenseConstants.IGNORED_KEYS, "UTF-8");
            String signature = new LicenseSigner().sign(licenseBytes, this.privateKeyInputStream);
            this.properties.setProperty("Signature", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException(e);
        }
        EnterpriseLicense license = new EnterpriseLicense(this.properties);
        license.verify();
        this.validateConstraints(license);
        return license;
    }

    private void validateConstraints(License license) {
        for (LicenseConstraint constraint : LicenseContraintsFactory.getAllContraints(license)) {
            constraint.verify();
        }
    }
}

