/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.offheapstore.storage.restartable.OffHeapObjectManagerStripe;
import java.nio.ByteBuffer;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.OffHeapStore;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;

public class EhcacheOffHeapObjectManagerStripe
extends OffHeapObjectManagerStripe<ByteBuffer> {
    private final OffHeapStore store;

    public EhcacheOffHeapObjectManagerStripe(ByteBuffer identifier, OffHeapStore store, EhcacheConcurrentOffHeapClockCache backing) {
        super(identifier, backing);
        this.store = store;
    }

    @Override
    public void replayPut(ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        while (true) {
            try {
                super.replayPut(frsBinaryKey, frsBinaryValue, lsn);
                return;
            }
            catch (CrossPoolEvictionException ex) {
                int hash = this.extractHashCode(frsBinaryKey);
                this.store.handleCrossPoolEvictionException(hash, ex);
                continue;
            }
            break;
        }
    }
}

