/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolEvictor;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;

public class OffHeapPoolEvictorImpl
implements OffHeapPoolEvictor {
    private static final int SAMPLE_SIZE = 5;
    private final long poolSize;

    public OffHeapPoolEvictorImpl(long poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public boolean freeSpace(Collection<PoolAccessor<OffHeapPoolParticipant>> from, long bytes) {
        return this.freeSpace(from, bytes, null, 0);
    }

    @Override
    public boolean freeSpace(Collection<PoolAccessor<OffHeapPoolParticipant>> from, long bytes, OffHeapPoolParticipant requestor, int excludedHash) {
        ArrayList<PoolAccessor<OffHeapPoolParticipant>> random = new ArrayList<PoolAccessor<OffHeapPoolParticipant>>(from);
        Collections.shuffle(random);
        for (int i = 0; i < random.size(); i += 5) {
            List<PoolAccessor<OffHeapPoolParticipant>> sorted = random.subList(i, Math.min(5 + i, random.size()));
            Collections.sort(sorted, new EvictionCostComparator(this.getDesiredUnloadedSize(sorted), sorted.size() + 1));
            for (PoolAccessor<OffHeapPoolParticipant> accessor : sorted) {
                if (!(accessor.getParticipant() == requestor ? accessor.getParticipant().evict(0, bytes, excludedHash) : accessor.getParticipant().evict(0, bytes))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean freeSpace(PoolAccessor<OffHeapPoolParticipant> preferential, Collection<PoolAccessor<OffHeapPoolParticipant>> from, long bytes) {
        if (from.size() == 1) {
            if (preferential.getParticipant().evict(0, bytes)) {
                return true;
            }
            throw CrossPoolEvictionException.INSTANCE;
        }
        List<PoolAccessor<OffHeapPoolParticipant>> subset = new ArrayList<PoolAccessor<OffHeapPoolParticipant>>(from);
        Collections.shuffle(subset);
        subset = subset.subList(0, Math.min(5, subset.size()));
        long unloadedSize = this.getDesiredUnloadedSize(subset);
        float localCost = OffHeapPoolEvictorImpl.evictionCost(preferential, unloadedSize);
        float costThreshold = Float.isInfinite(localCost) ? localCost : localCost - 0.1f * Math.abs(localCost);
        for (PoolAccessor<OffHeapPoolParticipant> participant : subset) {
            if (!(OffHeapPoolEvictorImpl.evictionCost(participant, unloadedSize) < costThreshold)) continue;
            throw CrossPoolEvictionException.INSTANCE;
        }
        if (preferential.getParticipant().evict(0, bytes)) {
            return true;
        }
        throw CrossPoolEvictionException.INSTANCE;
    }

    private static float evictionCost(PoolAccessor<OffHeapPoolParticipant> accessor, long unloadedSize) {
        float missRate;
        float hitRate = accessor.getParticipant().getApproximateHitRate();
        float accessRate = hitRate + (missRate = accessor.getParticipant().getApproximateMissRate());
        if (accessRate == 0.0f) {
            if (accessor.getSize() > unloadedSize) {
                return 0.0f;
            }
            return Float.MIN_NORMAL;
        }
        long countSize = accessor.getParticipant().getApproximateCountSize();
        float cost = accessRate / (float)countSize;
        if (Float.isNaN(cost)) {
            throw new AssertionError((Object)String.format("NaN Eviction Cost [hit:%f miss:%f size:%d]", Float.valueOf(hitRate), Float.valueOf(missRate), countSize));
        }
        return cost;
    }

    private long getDesiredUnloadedSize(Collection<PoolAccessor<OffHeapPoolParticipant>> from) {
        return this.poolSize / (long)from.size();
    }

    private static final class EvictionCostComparator
    implements Comparator<PoolAccessor<OffHeapPoolParticipant>> {
        private final long unloadedSize;
        private final Map<OffHeapPoolParticipant, Float> evictionCostCache;

        public EvictionCostComparator(long unloadedSize, int collectionSize) {
            this.unloadedSize = unloadedSize;
            this.evictionCostCache = new IdentityHashMap<OffHeapPoolParticipant, Float>(collectionSize);
        }

        @Override
        public int compare(PoolAccessor<OffHeapPoolParticipant> o1, PoolAccessor<OffHeapPoolParticipant> o2) {
            Float f2;
            Float f1 = this.evictionCostCache.get(o1.getParticipant());
            if (f1 == null) {
                f1 = Float.valueOf(OffHeapPoolEvictorImpl.evictionCost(o1, this.unloadedSize));
                this.evictionCostCache.put(o1.getParticipant(), f1);
            }
            if ((f2 = this.evictionCostCache.get(o2.getParticipant())) == null) {
                f2 = Float.valueOf(OffHeapPoolEvictorImpl.evictionCost(o2, this.unloadedSize));
                this.evictionCostCache.put(o2.getParticipant(), f2);
            }
            return Float.compare(f1.floatValue(), f2.floatValue());
        }
    }
}

