/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Sum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongSum
extends Sum {
    private boolean used = false;
    private long sum = 0L;

    public LongSum(String attributeName, ValueType type) {
        super(attributeName, type);
    }

    @Override
    public void accept(Object input) throws IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (!(input instanceof Number)) {
            throw new IllegalArgumentException(input.getClass().getName() + " is not a number for attribute [" + this.getAttributeName() + "]");
        }
        this.sum += ((Number)input).longValue();
        this.used = true;
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (incoming instanceof LongSum) {
            this.sum += ((LongSum)incoming).sum;
        } else {
            throw new IllegalArgumentException();
        }
        this.used = true;
    }

    @Override
    public Long getResult() {
        if (this.used) {
            return this.sum;
        }
        return null;
    }

    @Override
    public Aggregator deserializeData(DataInput input) throws IOException {
        this.used = input.readBoolean();
        this.sum = input.readLong();
        return this;
    }

    @Override
    public void serializeData(DataOutput output) throws IOException {
        output.writeBoolean(this.used);
        output.writeLong(this.sum);
    }
}

