/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Average;
import com.terracottatech.search.aggregator.Count;
import com.terracottatech.search.aggregator.MinMax;
import com.terracottatech.search.aggregator.Sum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractAggregator
implements Aggregator {
    private static final ValueType[] ALL_VALUE_TYPES = ValueType.values();
    private final String attributeName;
    private final ValueType type;
    private final AggregatorOperations operation;

    AbstractAggregator(AggregatorOperations operation, String attributeName, ValueType type) {
        this.attributeName = attributeName;
        this.type = type;
        this.operation = operation;
    }

    @Override
    public final String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public final ValueType getType() {
        return this.type;
    }

    public final AggregatorOperations getOperation() {
        return this.operation;
    }

    @Override
    public final void serializeTo(DataOutput output) throws IOException {
        output.writeUTF(this.getAttributeName());
        if (this.type == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(this.type.ordinal());
        }
        output.writeInt(this.operation.ordinal());
        this.serializeData(output);
    }

    public final Object deserializeFrom(DataInput input) throws IOException {
        return AbstractAggregator.deserializeInstance(input);
    }

    abstract Aggregator deserializeData(DataInput var1) throws IOException;

    abstract void serializeData(DataOutput var1) throws IOException;

    public static Aggregator deserializeInstance(DataInput input) throws IOException {
        String attributeName = input.readUTF();
        int typeIndex = input.readInt();
        ValueType type = typeIndex < 0 ? null : ALL_VALUE_TYPES[typeIndex];
        AggregatorOperations operation = AggregatorOperations.values()[input.readInt()];
        return AbstractAggregator.aggregator(operation, attributeName, type).deserializeData(input);
    }

    public static AbstractAggregator aggregator(AggregatorOperations operation, String attributeName, ValueType type) {
        switch (operation) {
            case AVERAGE: {
                return Average.average(attributeName, type);
            }
            case COUNT: {
                return new Count(attributeName, type);
            }
            case MAX: {
                return MinMax.max(attributeName, type);
            }
            case MIN: {
                return MinMax.min(attributeName, type);
            }
            case SUM: {
                return Sum.sum(attributeName, type);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return new StringBuilder(128).append("<Aggregator, type=").append((Object)this.operation).append(", value=").append(this.getResult()).append(", attributeName=").append(this.attributeName).append(", attributeType=").append((Object)this.type).append(">").toString();
    }
}

