/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.CachedDocIdResultSource;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexOwner;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.LuceneIndex;
import com.terracottatech.search.QueryInputs;
import com.terracottatech.search.SearchResultSource;
import java.io.File;
import java.io.IOException;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.store.FSDirectory;

class SearchResultSourceFactory {
    private final Configuration cfg;
    private final File indexDataPath;
    private IndexOwner owner;
    private LoggerFactory logFactory;
    private static final String subDirName = "search-results";

    SearchResultSourceFactory(Configuration config, File dataPath) {
        this.cfg = config;
        this.indexDataPath = dataPath;
    }

    SearchResultSourceFactory setIndexOwner(IndexOwner parent) {
        this.owner = parent;
        return this;
    }

    SearchResultSourceFactory setLoggerFactory(LoggerFactory logFactory) {
        this.logFactory = logFactory;
        return this;
    }

    SearchResultSource createSource(IndexReader reader, QueryInputs query) throws IndexException, IOException {
        CachedDocIdResultSource src = null;
        if (this.cfg.isSpoolSearchResults()) {
            File resPath = new File(this.indexDataPath, subDirName);
            Configuration conf = new Configuration(1, Integer.MAX_VALUE, false, false, false, -1, -1, -1);
            conf.setDisableStoredFieldCompression(true);
            conf.setDoAccessChecks(false);
            LuceneIndex resultsIndex = new LuceneIndex(FSDirectory.open(resPath), subDirName, resPath, this.owner, conf, this.logFactory);
        } else {
            src = new CachedDocIdResultSource(reader, query);
        }
        return src;
    }
}

