/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.offheapstore.disk.storage.FileBackedStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.listener.AbstractListenableStorageEngine;
import com.terracottatech.offheapstore.storage.restartable.DetachedLinkedNode;
import com.terracottatech.offheapstore.storage.restartable.LinkedNode;
import com.terracottatech.offheapstore.storage.restartable.LinkedNodePortability;
import com.terracottatech.offheapstore.storage.restartable.RestartableDelegateStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import com.terracottatech.offheapstore.util.Validation;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class RestartableStorageEngine<T extends StorageEngine<K, LinkedNode<V>> & RestartableDelegateStorageEngine, I, K, V>
extends AbstractListenableStorageEngine<K, V>
implements StorageEngine<K, V>,
ObjectManagerSegment<I, ByteBuffer, ByteBuffer>,
StorageEngine.Owner {
    private static final boolean VALIDATING = Validation.shouldValidate(RestartableStorageEngine.class);
    public static final long NULL_ENCODING = Long.MIN_VALUE;
    protected final T delegateStorageEngine;
    protected final I identifier;
    protected final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource;
    protected final boolean synchronous;
    protected volatile StorageEngine.Owner owner;
    private long first = Long.MIN_VALUE;
    private long last = Long.MIN_VALUE;
    private ObjectManagerEntry<I, ByteBuffer, ByteBuffer> compactingEntry;

    public static <T extends StorageEngine<K, LinkedNode<V>> & RestartableDelegateStorageEngine, I, K, V> Factory<RestartableStorageEngine<T, I, K, V>> createFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final Factory<T> delegateFactory, final boolean synchronous) {
        return new Factory<RestartableStorageEngine<T, I, K, V>>(){

            @Override
            public RestartableStorageEngine<T, I, K, V> newInstance() {
                return new RestartableStorageEngine(identifier, transactionSource, (StorageEngine)delegateFactory.newInstance(), synchronous);
            }
        };
    }

    public RestartableStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, T storageEngine, boolean synchronous) {
        this.identifier = identifier;
        this.transactionSource = transactionSource;
        this.delegateStorageEngine = storageEngine;
        this.synchronous = synchronous;
    }

    @Override
    public Long writeMapping(K key, V value, int hash, int metadata) {
        Long result = this.delegateStorageEngine.writeMapping(key, new DetachedLinkedNode<V>(value), hash, metadata);
        if (result != null && this.hasListeners()) {
            ByteBuffer offheapBinaryKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(result);
            ByteBuffer offheapBinaryValue = ((ByteBuffer)((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryValue(result).position(24)).slice();
            this.fireWritten(key, value, offheapBinaryKey, offheapBinaryValue, hash, metadata, result);
        }
        return result;
    }

    @Override
    public void attachedMapping(long encoding, int hash, int metadata) {
        this.restartabilityPut(encoding, hash, metadata);
    }

    protected void restartabilityPut(long encoding, int pojoHash, int metadata) {
        ByteBuffer offheapBinaryKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(encoding);
        ByteBuffer offheapBinaryValue = ((ByteBuffer)((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryValue(encoding).position(24)).slice();
        ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(offheapBinaryKey, pojoHash);
        ByteBuffer frsBinaryValue = RestartableStorageEngine.encodeValue(offheapBinaryValue, encoding, metadata);
        try {
            this.transactionSource.beginTransaction(this.synchronous).put(this.identifier, frsBinaryKey, frsBinaryValue).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freeMapping(long encoding, int hash, boolean removal) {
        LinkedNode node = (LinkedNode)this.delegateStorageEngine.readValue(encoding);
        this.unlinkNode(node, encoding);
        node.flush();
        if (removal) {
            this.restartabilityRemove(encoding);
        }
        if (this.hasListeners()) {
            ByteBuffer rawKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(encoding);
            this.delegateStorageEngine.freeMapping(encoding, hash, removal);
            this.validChain();
            this.fireFreed(encoding, hash, rawKey, removal);
        } else {
            this.delegateStorageEngine.freeMapping(encoding, hash, removal);
            this.validChain();
        }
    }

    private void restartabilityRemove(long encoding) {
        ByteBuffer offheapBinaryKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(encoding);
        int pojoHash = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readPojoHash(encoding);
        ByteBuffer frsBinaryKey = RestartableStorageEngine.encodeKey(offheapBinaryKey, pojoHash);
        try {
            this.transactionSource.beginTransaction(this.synchronous).remove(this.identifier, frsBinaryKey).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V readValue(long encoding) {
        return (V)((LinkedNode)this.delegateStorageEngine.readValue(encoding)).getValue();
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.delegateStorageEngine.equalsValue(value, encoding);
    }

    @Override
    public K readKey(long encoding, int hashCode) {
        return this.delegateStorageEngine.readKey(encoding, hashCode);
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return this.delegateStorageEngine.equalsKey(key, encoding);
    }

    public boolean equalsBinaryKey(ByteBuffer offheapBinaryKey, long encoding) {
        return ((RestartableDelegateStorageEngine)this.delegateStorageEngine).equalsBinaryKey(offheapBinaryKey, encoding);
    }

    @Override
    public void clear() {
        this.first = Long.MIN_VALUE;
        this.last = Long.MIN_VALUE;
        this.restartabilityDelete();
        this.delegateStorageEngine.clear();
        this.validChain();
        this.fireCleared();
    }

    private void restartabilityDelete() {
        try {
            this.transactionSource.beginTransaction(this.synchronous).delete(this.identifier).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getAllocatedMemory() {
        return this.delegateStorageEngine.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.delegateStorageEngine.getOccupiedMemory();
    }

    @Override
    public void invalidateCache() {
        this.delegateStorageEngine.invalidateCache();
    }

    @Override
    public void bind(StorageEngine.Owner owner) {
        this.owner = owner;
        this.delegateStorageEngine.bind(this);
    }

    @Override
    public void destroy() {
        this.delegateStorageEngine.destroy();
    }

    @Override
    public boolean shrink() {
        return this.delegateStorageEngine.shrink();
    }

    protected final void assignLsn(long encoding, long lsn) {
        LinkedNode node = (LinkedNode)this.delegateStorageEngine.readValue(encoding);
        this.unlinkNode(node, encoding);
        this.linkNodeExpectingLast(node, encoding, lsn);
        node.setLsn(lsn);
        node.flush();
        this.validChain();
    }

    protected final void unlinkNode(LinkedNode<?> node, long encoding) {
        if (this.last == encoding) {
            this.last = node.getPrevious();
        }
        if (this.first == encoding) {
            this.first = node.getNext();
        }
        if (node.getNext() != Long.MIN_VALUE) {
            LinkedNode next = (LinkedNode)this.delegateStorageEngine.readValue(node.getNext());
            next.setPrevious(node.getPrevious());
            next.flush();
        }
        if (node.getPrevious() != Long.MIN_VALUE) {
            LinkedNode previous = (LinkedNode)this.delegateStorageEngine.readValue(node.getPrevious());
            previous.setNext(node.getNext());
            previous.flush();
        }
        node.setNext(Long.MIN_VALUE);
        node.setPrevious(Long.MIN_VALUE);
    }

    protected final void linkNodeExpectingLast(LinkedNode<?> node, long encoding, long lsn) {
        long nextEncoding;
        if (lsn < 0L) {
            throw new AssertionError((Object)("Received illegal lsn " + lsn));
        }
        if (this.last == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || this.first == Long.MIN_VALUE);
            this.last = encoding;
            this.first = encoding;
            return;
        }
        long previousEncoding = this.last;
        LinkedNode previous = (LinkedNode)this.delegateStorageEngine.readValue(previousEncoding);
        while (true) {
            if (previous.getLsn() < lsn) {
                nextEncoding = previous.getNext();
                break;
            }
            if (previous.getPrevious() == Long.MIN_VALUE) {
                nextEncoding = previousEncoding;
                previousEncoding = Long.MIN_VALUE;
                previous = null;
                break;
            }
            previousEncoding = previous.getPrevious();
            previous = (LinkedNode)this.delegateStorageEngine.readValue(previousEncoding);
        }
        if (nextEncoding == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || previousEncoding == this.last);
            this.last = encoding;
            node.setPrevious(previousEncoding);
            previous.setNext(encoding);
            previous.flush();
        } else {
            LinkedNode next = (LinkedNode)this.delegateStorageEngine.readValue(nextEncoding);
            if (previousEncoding == Long.MIN_VALUE) {
                Validation.validate(!VALIDATING || nextEncoding == this.first);
                this.first = encoding;
                node.setNext(nextEncoding);
                next.setPrevious(encoding);
                next.flush();
            } else {
                node.setNext(nextEncoding);
                node.setPrevious(previousEncoding);
                previous.setNext(encoding);
                next.setPrevious(encoding);
                previous.flush();
                next.flush();
            }
        }
    }

    protected final void linkNodeExpectingFirst(LinkedNode<?> node, long encoding, long lsn) {
        long previousEncoding;
        if (lsn < 0L) {
            throw new AssertionError((Object)("Received illegal lsn " + lsn));
        }
        if (this.last == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || this.first == Long.MIN_VALUE);
            this.last = encoding;
            this.first = encoding;
            return;
        }
        long nextEncoding = this.first;
        LinkedNode next = (LinkedNode)this.delegateStorageEngine.readValue(nextEncoding);
        while (true) {
            if (next.getLsn() > lsn) {
                previousEncoding = next.getPrevious();
                break;
            }
            if (next.getNext() == Long.MIN_VALUE) {
                previousEncoding = nextEncoding;
                nextEncoding = Long.MIN_VALUE;
                next = null;
                break;
            }
            nextEncoding = next.getNext();
            next = (LinkedNode)this.delegateStorageEngine.readValue(nextEncoding);
        }
        if (previousEncoding == Long.MIN_VALUE) {
            Validation.validate(!VALIDATING || nextEncoding == this.first);
            this.first = encoding;
            node.setNext(nextEncoding);
            next.setPrevious(encoding);
            next.flush();
        } else {
            LinkedNode previous = (LinkedNode)this.delegateStorageEngine.readValue(previousEncoding);
            if (nextEncoding == Long.MIN_VALUE) {
                Validation.validate(!VALIDATING || previousEncoding == this.last);
                this.last = encoding;
                node.setPrevious(previousEncoding);
                previous.setNext(encoding);
                previous.flush();
            } else {
                node.setPrevious(previousEncoding);
                node.setNext(nextEncoding);
                next.setPrevious(encoding);
                previous.setNext(encoding);
                previous.flush();
                next.flush();
            }
        }
    }

    protected final void validChain() {
        if (VALIDATING) {
            if (this.delegateStorageEngine instanceof FileBackedStorageEngine) {
                return;
            }
            long previous = Long.MIN_VALUE;
            LinkedNode previousNode = null;
            long current = this.first;
            while (true) {
                if (current == Long.MIN_VALUE) {
                    Validation.validate(this.last == previous);
                    break;
                }
                LinkedNode currentNode = (LinkedNode)this.delegateStorageEngine.readValue(current);
                Validation.validate(!VALIDATING || currentNode.getPrevious() == previous);
                if (previousNode == null) {
                    Validation.validate(previous == Long.MIN_VALUE);
                } else {
                    Validation.validate(previousNode.getNext() == current);
                }
                previous = current;
                previousNode = currentNode;
                current = currentNode.getNext();
            }
        }
    }

    protected long firstEncoding() {
        return this.first;
    }

    protected long lastEncoding() {
        return this.last;
    }

    @Override
    public long size() {
        return this.owner.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLowestLsn() {
        Lock l = ((ReadWriteLock)this.delegateStorageEngine).readLock();
        l.lock();
        try {
            long lowest = this.firstEncoding();
            if (lowest == Long.MIN_VALUE) {
                Long l2 = null;
                return l2;
            }
            Long l3 = ((LinkedNode)this.delegateStorageEngine.readValue(lowest)).getLsn();
            return l3;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLsn(int pojoHash, ByteBuffer frsBinaryKey) {
        ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
        Lock l = ((ReadWriteLock)this.delegateStorageEngine).readLock();
        l.lock();
        try {
            Long encoding = this.lookupEncoding(pojoHash, offheapBinaryKey);
            if (encoding == null) {
                Long l2 = null;
                return l2;
            }
            Long l3 = ((LinkedNode)this.delegateStorageEngine.readValue(encoding)).getLsn();
            return l3;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int pojoHash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        long encoding = RestartableStorageEngine.extractEncoding(frsBinaryValue);
        Lock l = ((ReadWriteLock)this.delegateStorageEngine).writeLock();
        l.lock();
        try {
            this.assignLsn(encoding, lsn);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void remove(int pojoHash, ByteBuffer frsBinaryKey) {
        Validation.validate(!VALIDATING || this.lookupEncoding(pojoHash, RestartableStorageEngine.decodeKey(frsBinaryKey)) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replayPut(final int pojoHash, ByteBuffer frsBinaryKey, ByteBuffer frsBinaryValue, long lsn) {
        int metadata = RestartableStorageEngine.extractMetadata(frsBinaryValue);
        ByteBuffer offheapBinaryKey = RestartableStorageEngine.decodeKey(frsBinaryKey);
        ByteBuffer offheapBinaryValue = RestartableStorageEngine.decodeValue(frsBinaryValue);
        Lock l = ((ReadWriteLock)this.delegateStorageEngine).writeLock();
        l.lock();
        try {
            final long encoding = this.owner.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
            LinkedNode node = (LinkedNode)this.delegateStorageEngine.readValue(encoding);
            this.linkNodeExpectingFirst(node, encoding, lsn);
            node.setLsn(lsn);
            node.flush();
            this.validChain();
            if (this.hasRecoveryListeners()) {
                ByteBuffer binaryKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(encoding);
                ByteBuffer binaryValue = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryValue(encoding);
                final Thread caller = Thread.currentThread();
                this.fireRecovered(new Callable<K>(){

                    @Override
                    public K call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return RestartableStorageEngine.this.readKey(encoding, pojoHash);
                        }
                        throw new IllegalStateException();
                    }
                }, new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return RestartableStorageEngine.this.readValue(encoding);
                        }
                        throw new IllegalStateException();
                    }
                }, binaryKey, binaryValue, pojoHash, metadata, encoding);
            }
        }
        finally {
            l.unlock();
        }
    }

    public Long installMapping(ByteBuffer offheapBinaryKey, ByteBuffer offheapBinaryValue, int pojoHash, int metadata) {
        return ((RestartableDelegateStorageEngine)this.delegateStorageEngine).writeBinaryMapping(new ByteBuffer[]{offheapBinaryKey.duplicate()}, new ByteBuffer[]{LinkedNodePortability.emptyHeader(), offheapBinaryValue.duplicate()}, pojoHash, metadata);
    }

    @Override
    public ObjectManagerEntry<I, ByteBuffer, ByteBuffer> acquireCompactionEntry(long ceilingLsn) {
        Lock l = ((ReadWriteLock)this.delegateStorageEngine).writeLock();
        l.lock();
        long encoding = this.firstEncoding();
        if (encoding == Long.MIN_VALUE) {
            l.unlock();
            return null;
        }
        try {
            LinkedNode node = (LinkedNode)this.delegateStorageEngine.readValue(encoding);
            if (node.getLsn() >= ceilingLsn) {
                l.unlock();
                return null;
            }
            int metadata = this.deriveMetadata(encoding);
            ByteBuffer offheapBinaryKey = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryKey(encoding);
            ByteBuffer offheapBinaryValue = ((ByteBuffer)((RestartableDelegateStorageEngine)this.delegateStorageEngine).readBinaryValue(encoding).position(24)).slice();
            int hash = ((RestartableDelegateStorageEngine)this.delegateStorageEngine).readPojoHash(encoding);
            this.compactingEntry = new SimpleObjectManagerEntry<I, ByteBuffer, ByteBuffer>(this.identifier, RestartableStorageEngine.encodeKey(offheapBinaryKey, hash), RestartableStorageEngine.encodeValue(offheapBinaryValue, encoding, metadata), node.getLsn());
            return this.compactingEntry;
        }
        catch (RuntimeException e) {
            l.unlock();
            throw e;
        }
        catch (Error e) {
            l.unlock();
            throw e;
        }
        catch (Throwable e) {
            l.unlock();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void releaseCompactionEntry(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry) {
        if (entry == null) {
            throw new NullPointerException("Tried to release a null entry.");
        }
        if (entry != this.compactingEntry) {
            throw new IllegalArgumentException("Released entry is not the same as acquired entry.");
        }
        this.compactingEntry = null;
        ((ReadWriteLock)this.delegateStorageEngine).writeLock().unlock();
    }

    @Override
    public void updateLsn(int pojoHash, ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        if (entry != this.compactingEntry) {
            throw new IllegalArgumentException("Tried to update the LSN on an entry that was not acquired.");
        }
        long encoding = RestartableStorageEngine.extractEncoding(entry.getValue());
        Validation.validate(!VALIDATING || ((LinkedNode)this.delegateStorageEngine.readValue(encoding)).getLsn() == entry.getLsn());
        this.assignLsn(encoding, newLsn);
    }

    private Long lookupEncoding(int hash, ByteBuffer offHeapBinaryKey) {
        return this.owner.getEncodingForHashAndBinary(hash, offHeapBinaryKey);
    }

    protected int deriveMetadata(long encoding) {
        return 0;
    }

    public static ByteBuffer encodeKey(ByteBuffer offheapBinaryKey, int pojoHash) {
        ByteBuffer frsBinaryKey = ByteBuffer.allocate(offheapBinaryKey.remaining() + 4);
        frsBinaryKey.putInt(pojoHash).put(offheapBinaryKey).flip();
        return frsBinaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decodeKey(ByteBuffer frsBinaryKey) {
        int origPos = frsBinaryKey.position();
        try {
            ByteBuffer byteBuffer = ((ByteBuffer)frsBinaryKey.position(origPos + 4)).slice();
            return byteBuffer;
        }
        finally {
            frsBinaryKey.position(origPos);
        }
    }

    public static int extractHashcode(ByteBuffer frsBinaryKey) {
        return frsBinaryKey.getInt(0);
    }

    public static ByteBuffer encodeValue(ByteBuffer offheapBinaryValue, long encoding, int metadata) {
        ByteBuffer frsBinaryValue = ByteBuffer.allocate(offheapBinaryValue.remaining() + 12);
        frsBinaryValue.putLong(encoding).putInt(metadata).put(offheapBinaryValue).flip();
        return frsBinaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer decodeValue(ByteBuffer frsBinaryValue) {
        int origPos = frsBinaryValue.position();
        try {
            ByteBuffer byteBuffer = ((ByteBuffer)frsBinaryValue.position(origPos + 12)).slice();
            return byteBuffer;
        }
        finally {
            frsBinaryValue.position(origPos);
        }
    }

    public static int extractMetadata(ByteBuffer frsBinaryValue) {
        return frsBinaryValue.getInt(8) & 0xBFFFFFFF;
    }

    public static long extractEncoding(ByteBuffer frsBinaryValue) {
        return frsBinaryValue.getLong(0);
    }

    @Override
    public long sizeInBytes() {
        return this.delegateStorageEngine.getOccupiedMemory();
    }

    @Override
    public Long getEncodingForHashAndBinary(int hash, ByteBuffer offHeapBinaryKey) {
        return this.owner.getEncodingForHashAndBinary(hash, offHeapBinaryKey);
    }

    @Override
    public long getSize() {
        return this.owner.getSize();
    }

    @Override
    public long installMappingForHashAndEncoding(int pojoHash, ByteBuffer offheapBinaryKey, ByteBuffer offheapBinaryValue, int metadata) {
        return this.owner.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
    }

    @Override
    public Iterable<Long> encodingSet() {
        return this.owner.encodingSet();
    }

    @Override
    public boolean updateEncoding(int hashCode, long lastAddress, long compressed, long mask) {
        if (this.owner.updateEncoding(hashCode, lastAddress, compressed, mask)) {
            LinkedNode node = (LinkedNode)this.delegateStorageEngine.readValue(compressed);
            if (this.last == lastAddress) {
                this.last = compressed;
            }
            if (this.first == lastAddress) {
                this.first = compressed;
            }
            if (node.getNext() != Long.MIN_VALUE) {
                LinkedNode next = (LinkedNode)this.delegateStorageEngine.readValue(node.getNext());
                next.setPrevious(compressed);
                next.flush();
            }
            if (node.getPrevious() != Long.MIN_VALUE) {
                LinkedNode previous = (LinkedNode)this.delegateStorageEngine.readValue(node.getPrevious());
                previous.setNext(compressed);
                previous.flush();
            }
            node.flush();
            this.validChain();
            return true;
        }
        return false;
    }

    @Override
    public Integer getSlotForHashAndEncoding(int hash, long address, long mask) {
        return this.owner.getSlotForHashAndEncoding(hash, address, mask);
    }

    @Override
    public boolean evict(int slot, boolean b) {
        return this.owner.evict(slot, b);
    }

    @Override
    public boolean isThiefForTableAllocations() {
        return this.owner.isThiefForTableAllocations();
    }

    @Override
    public Lock readLock() {
        return this.owner.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.owner.writeLock();
    }
}

