/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import org.terracotta.shaded.lucene.index.AtomicReader;
import org.terracotta.shaded.lucene.index.DocTermOrds;
import org.terracotta.shaded.lucene.index.TermsEnum;
import org.terracotta.shaded.lucene.search.FieldCacheImpl;
import org.terracotta.shaded.lucene.util.Bits;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.NumericUtils;
import org.terracotta.shaded.lucene.util.RamUsageEstimator;
import org.terracotta.shaded.lucene.util.packed.PackedInts;

public interface FieldCache {
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final ByteParser DEFAULT_BYTE_PARSER = new ByteParser(){

        @Override
        public byte parseByte(BytesRef term) {
            return Byte.parseByte(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_BYTE_PARSER";
        }
    };
    public static final ShortParser DEFAULT_SHORT_PARSER = new ShortParser(){

        @Override
        public short parseShort(BytesRef term) {
            return Short.parseShort(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_SHORT_PARSER";
        }
    };
    public static final IntParser DEFAULT_INT_PARSER = new IntParser(){

        @Override
        public int parseInt(BytesRef term) {
            return Integer.parseInt(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_INT_PARSER";
        }
    };
    public static final FloatParser DEFAULT_FLOAT_PARSER = new FloatParser(){

        @Override
        public float parseFloat(BytesRef term) {
            return Float.parseFloat(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_FLOAT_PARSER";
        }
    };
    public static final LongParser DEFAULT_LONG_PARSER = new LongParser(){

        @Override
        public long parseLong(BytesRef term) {
            return Long.parseLong(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_LONG_PARSER";
        }
    };
    public static final DoubleParser DEFAULT_DOUBLE_PARSER = new DoubleParser(){

        @Override
        public double parseDouble(BytesRef term) {
            return Double.parseDouble(term.utf8ToString());
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_DOUBLE_PARSER";
        }
    };
    public static final IntParser NUMERIC_UTILS_INT_PARSER = new IntParser(){

        @Override
        public int parseInt(BytesRef term) {
            if (NumericUtils.getPrefixCodedIntShift(term) > 0) {
                throw new StopFillCacheException();
            }
            return NumericUtils.prefixCodedToInt(term);
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_INT_PARSER";
        }
    };
    public static final FloatParser NUMERIC_UTILS_FLOAT_PARSER = new FloatParser(){

        @Override
        public float parseFloat(BytesRef term) {
            if (NumericUtils.getPrefixCodedIntShift(term) > 0) {
                throw new StopFillCacheException();
            }
            return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(term));
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_FLOAT_PARSER";
        }
    };
    public static final LongParser NUMERIC_UTILS_LONG_PARSER = new LongParser(){

        @Override
        public long parseLong(BytesRef term) {
            if (NumericUtils.getPrefixCodedLongShift(term) > 0) {
                throw new StopFillCacheException();
            }
            return NumericUtils.prefixCodedToLong(term);
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_LONG_PARSER";
        }
    };
    public static final DoubleParser NUMERIC_UTILS_DOUBLE_PARSER = new DoubleParser(){

        @Override
        public double parseDouble(BytesRef term) {
            if (NumericUtils.getPrefixCodedLongShift(term) > 0) {
                throw new StopFillCacheException();
            }
            return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(term));
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_DOUBLE_PARSER";
        }
    };

    public Bits getDocsWithField(AtomicReader var1, String var2) throws IOException;

    public byte[] getBytes(AtomicReader var1, String var2, boolean var3) throws IOException;

    public byte[] getBytes(AtomicReader var1, String var2, ByteParser var3, boolean var4) throws IOException;

    public short[] getShorts(AtomicReader var1, String var2, boolean var3) throws IOException;

    public short[] getShorts(AtomicReader var1, String var2, ShortParser var3, boolean var4) throws IOException;

    public int[] getInts(AtomicReader var1, String var2, boolean var3) throws IOException;

    public int[] getInts(AtomicReader var1, String var2, IntParser var3, boolean var4) throws IOException;

    public float[] getFloats(AtomicReader var1, String var2, boolean var3) throws IOException;

    public float[] getFloats(AtomicReader var1, String var2, FloatParser var3, boolean var4) throws IOException;

    public long[] getLongs(AtomicReader var1, String var2, boolean var3) throws IOException;

    public long[] getLongs(AtomicReader var1, String var2, LongParser var3, boolean var4) throws IOException;

    public double[] getDoubles(AtomicReader var1, String var2, boolean var3) throws IOException;

    public double[] getDoubles(AtomicReader var1, String var2, DoubleParser var3, boolean var4) throws IOException;

    public DocTerms getTerms(AtomicReader var1, String var2) throws IOException;

    public DocTerms getTerms(AtomicReader var1, String var2, float var3) throws IOException;

    public DocTermsIndex getTermsIndex(AtomicReader var1, String var2) throws IOException;

    public DocTermsIndex getTermsIndex(AtomicReader var1, String var2, float var3) throws IOException;

    public DocTermOrds getDocTermOrds(AtomicReader var1, String var2) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purge(AtomicReader var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    public static abstract class CacheEntry {
        private String size = null;

        public abstract Object getReaderKey();

        public abstract String getFieldName();

        public abstract Class<?> getCacheType();

        public abstract Object getCustom();

        public abstract Object getValue();

        protected final void setEstimatedSize(String size) {
            this.size = size;
        }

        public void estimateSize() {
            long size = RamUsageEstimator.sizeOf(this.getValue());
            this.setEstimatedSize(RamUsageEstimator.humanReadableUnits(size));
        }

        public final String getEstimatedSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("'").append(this.getReaderKey()).append("'=>");
            b.append("'").append(this.getFieldName()).append("',");
            b.append(this.getCacheType()).append(",").append(this.getCustom());
            b.append("=>").append(this.getValue().getClass().getName()).append("#");
            b.append(System.identityHashCode(this.getValue()));
            String s = this.getEstimatedSize();
            if (null != s) {
                b.append(" (size =~ ").append(s).append(')');
            }
            return b.toString();
        }
    }

    public static abstract class DocTermsIndex {
        public int binarySearchLookup(BytesRef key, BytesRef spare) {
            if (key == null) {
                return 0;
            }
            int low = 1;
            int high = this.numOrd() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = this.lookup(mid, spare).compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public abstract BytesRef lookup(int var1, BytesRef var2);

        public BytesRef getTerm(int docID, BytesRef reuse) {
            return this.lookup(this.getOrd(docID), reuse);
        }

        public abstract int getOrd(int var1);

        public abstract int numOrd();

        public abstract int size();

        public abstract TermsEnum getTermsEnum();

        public abstract PackedInts.Reader getDocToOrd();
    }

    public static abstract class DocTerms {
        public abstract BytesRef getTerm(int var1, BytesRef var2);

        public abstract boolean exists(int var1);

        public abstract int size();
    }

    public static interface DoubleParser
    extends Parser {
        public double parseDouble(BytesRef var1);
    }

    public static interface LongParser
    extends Parser {
        public long parseLong(BytesRef var1);
    }

    public static interface FloatParser
    extends Parser {
        public float parseFloat(BytesRef var1);
    }

    public static interface IntParser
    extends Parser {
        public int parseInt(BytesRef var1);
    }

    public static interface ShortParser
    extends Parser {
        public short parseShort(BytesRef var1);
    }

    public static interface ByteParser
    extends Parser {
        public byte parseByte(BytesRef var1);
    }

    public static interface Parser {
    }

    public static final class StopFillCacheException
    extends RuntimeException {
    }

    public static final class CreationPlaceholder {
        Object value;
    }
}

