/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import org.terracotta.shaded.lucene.document.ByteDocValuesField;
import org.terracotta.shaded.lucene.document.DerefBytesDocValuesField;
import org.terracotta.shaded.lucene.document.DoubleDocValuesField;
import org.terracotta.shaded.lucene.document.Field;
import org.terracotta.shaded.lucene.document.FloatDocValuesField;
import org.terracotta.shaded.lucene.document.IntDocValuesField;
import org.terracotta.shaded.lucene.document.LongDocValuesField;
import org.terracotta.shaded.lucene.document.PackedLongDocValuesField;
import org.terracotta.shaded.lucene.document.ShortDocValuesField;
import org.terracotta.shaded.lucene.document.SortedBytesDocValuesField;
import org.terracotta.shaded.lucene.document.StraightBytesDocValuesField;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.util.BytesRef;

public final class Norm {
    private Field field;
    private BytesRef spare;

    public IndexableField field() {
        return this.field;
    }

    public DocValues.Type type() {
        return this.field == null ? null : this.field.fieldType().docValueType();
    }

    public BytesRef getSpare() {
        if (this.spare == null) {
            this.spare = new BytesRef();
        }
        return this.spare;
    }

    public void setFloat(float norm) {
        this.setType(DocValues.Type.FLOAT_32);
        this.field.setFloatValue(norm);
    }

    public void setDouble(double norm) {
        this.setType(DocValues.Type.FLOAT_64);
        this.field.setDoubleValue(norm);
    }

    public void setShort(short norm) {
        this.setType(DocValues.Type.FIXED_INTS_16);
        this.field.setShortValue(norm);
    }

    public void setInt(int norm) {
        this.setType(DocValues.Type.FIXED_INTS_32);
        this.field.setIntValue(norm);
    }

    public void setLong(long norm) {
        this.setType(DocValues.Type.FIXED_INTS_64);
        this.field.setLongValue(norm);
    }

    public void setByte(byte norm) {
        this.setType(DocValues.Type.FIXED_INTS_8);
        this.field.setByteValue(norm);
    }

    public void setBytes(BytesRef norm) {
        this.setType(DocValues.Type.BYTES_FIXED_STRAIGHT);
        this.field.setBytesValue(norm);
    }

    private void setType(DocValues.Type type) {
        if (this.field != null) {
            if (type != this.field.fieldType().docValueType()) {
                throw new IllegalArgumentException("FieldType missmatch - expected " + (Object)((Object)type) + " but was " + (Object)((Object)this.field.fieldType().docValueType()));
            }
        } else {
            switch (type) {
                case VAR_INTS: {
                    this.field = new PackedLongDocValuesField("", 0L);
                    break;
                }
                case FIXED_INTS_8: {
                    this.field = new ByteDocValuesField("", 0);
                    break;
                }
                case FIXED_INTS_16: {
                    this.field = new ShortDocValuesField("", 0);
                    break;
                }
                case FIXED_INTS_32: {
                    this.field = new IntDocValuesField("", 0);
                    break;
                }
                case FIXED_INTS_64: {
                    this.field = new LongDocValuesField("", 0L);
                    break;
                }
                case FLOAT_32: {
                    this.field = new FloatDocValuesField("", 0.0f);
                    break;
                }
                case FLOAT_64: {
                    this.field = new DoubleDocValuesField("", 0.0);
                    break;
                }
                case BYTES_FIXED_STRAIGHT: {
                    this.field = new StraightBytesDocValuesField("", new BytesRef(), true);
                    break;
                }
                case BYTES_VAR_STRAIGHT: {
                    this.field = new StraightBytesDocValuesField("", new BytesRef(), false);
                    break;
                }
                case BYTES_FIXED_DEREF: {
                    this.field = new DerefBytesDocValuesField("", new BytesRef(), true);
                    break;
                }
                case BYTES_VAR_DEREF: {
                    this.field = new DerefBytesDocValuesField("", new BytesRef(), false);
                    break;
                }
                case BYTES_FIXED_SORTED: {
                    this.field = new SortedBytesDocValuesField("", new BytesRef(), true);
                    break;
                }
                case BYTES_VAR_SORTED: {
                    this.field = new SortedBytesDocValuesField("", new BytesRef(), false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown Type: " + (Object)((Object)type));
                }
            }
        }
    }
}

