/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.buffersource.BufferSource;
import com.terracottatech.offheapstore.buffersource.OffHeapBufferSource;
import com.terracottatech.offheapstore.buffersource.TimingBufferSource;
import com.terracottatech.offheapstore.concurrent.ConcurrentOffHeapClockCache;
import com.terracottatech.offheapstore.paging.UpfrontAllocatingPageSource;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.PointerSize;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.storage.restartable.LinkedNodePortability;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.statistics.StatisticBuilder;
import net.sf.ehcache.store.cachingtier.OnHeapCachingTier;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.OffHeapStore;
import net.sf.ehcache.store.offheap.RestartableOffheapStore;
import net.sf.ehcache.store.offheap.cachingtier.CachingTierEvictionListener;
import net.sf.ehcache.store.offheap.cachingtier.CachingTierPooledSegmentFactory;
import net.sf.ehcache.store.offheap.cachingtier.OffHeapCachingTier;
import net.sf.ehcache.store.offheap.configuration.AdvancedConfigPropertyParser;
import net.sf.ehcache.store.offheap.configuration.HeuristicConfiguration;
import net.sf.ehcache.store.offheap.configuration.OffHeapConfiguration;
import net.sf.ehcache.store.offheap.factories.EhcachePooledSegmentFactory;
import net.sf.ehcache.store.offheap.factories.EhcacheSegmentFactory;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.portability.EhcacheElementPortability;
import net.sf.ehcache.store.offheap.portability.EhcacheKeyPortability;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import net.sf.ehcache.store.restartability.EhcacheOffHeapObjectManagerStripe;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.observer.OperationObserver;

public final class OffHeapStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapStoreFactory.class);
    private static final long SLOW_DELAY = 3000L;
    private static final String SLOW_DELAY_PROPERTY = "slowAllocationDelay";
    private static final long CRITICAL_DELAY = 30000L;
    private static final String CRITICAL_DELAY_PROPERTY = "criticalAllocationDelay";
    private static final boolean HALT_ON_CRITICAL_DELAY = true;
    private static final String HALT_ON_CRITICAL_DELAY_PROPERTY = "haltOnCriticalAllocationDelay";

    private OffHeapStoreFactory() {
    }

    public static OffHeapStore createAuthority(final Cache cache, final OffHeapPool offHeapPool, final LuceneIndexedSearchManager searchManager) {
        return new OffHeapStore(new BackingMapFactory<EhcacheConcurrentOffHeapClockCache, OffHeapStore>(){

            @Override
            public EhcacheConcurrentOffHeapClockCache create(OffHeapStore store, OffHeapPoolParticipant participant) {
                CacheConfiguration config = cache.getCacheConfiguration();
                OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.EvictionOutcome.class).of(store)).named("eviction")).build();
                if (offHeapPool != null) {
                    return OffHeapStoreFactory.createPooledBackingMap(offHeapPool, participant, cache.getCacheEventNotificationService(), evictionObserver, config, searchManager);
                }
                return OffHeapStoreFactory.createBackingMap(cache.getCacheEventNotificationService(), evictionObserver, new HeuristicConfiguration(cache.getName(), config.getMaxBytesLocalOffHeap()), config, searchManager);
            }
        }, cache, offHeapPool, searchManager);
    }

    public static OffHeapCachingTier createCachingTier(final Cache cache, final OffHeapPool offHeapPool, OnHeapCachingTier onHeapCache) {
        final CachingTierEvictionListener cachingTierEvictionListener = new CachingTierEvictionListener();
        return new OffHeapCachingTier<Serializable, Element>(onHeapCache, new BackingMapFactory<ConcurrentOffHeapClockCache<Serializable, Element>, OffHeapCachingTier<Serializable, Element>>(){

            @Override
            public ConcurrentOffHeapClockCache<Serializable, Element> create(OffHeapCachingTier<Serializable, Element> store, OffHeapPoolParticipant participant) {
                CacheConfiguration cacheConfig = cache.getCacheConfiguration();
                if (offHeapPool != null) {
                    OffHeapConfiguration config = offHeapPool.getPoolConfiguration();
                    EhcacheKeyPortability keyPortability = new EhcacheKeyPortability();
                    EhcacheElementPortability elementPortability = new EhcacheElementPortability(cacheConfig);
                    Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, offHeapPool.getPageSource(), config.getSegmentDataPageSize(), keyPortability, elementPortability, false, true);
                    CachingTierPooledSegmentFactory segmentFactory = new CachingTierPooledSegmentFactory(offHeapPool.getPageSource(), storageEngineFactory, cachingTierEvictionListener, config.getInitialSegmentTableSize(), participant, offHeapPool);
                    return new ConcurrentOffHeapClockCache<Serializable, Element>(segmentFactory, config.getConcurrency());
                }
                HeuristicConfiguration config = new HeuristicConfiguration(cache.getName(), cacheConfig.getMaxBytesLocalOffHeap());
                UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreFactory.getBufferSource(cacheConfig.getName()), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
                EhcacheKeyPortability keyPortability = new EhcacheKeyPortability();
                EhcacheElementPortability elementPortability = new EhcacheElementPortability(cacheConfig);
                Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, source, config.getSegmentDataPageSize(), keyPortability, elementPortability, false, true);
                return new ConcurrentOffHeapClockCache<Serializable, Element>(source, storageEngineFactory, cachingTierEvictionListener);
            }
        }, cachingTierEvictionListener.getListeners(), offHeapPool);
    }

    public static OffHeapStore createRestartableAuthority(final EhcacheRestartability restartability, final Cache cache, final OffHeapPool offHeapPool, final LuceneIndexedSearchManager searchManager, final boolean synchronousWrites) {
        return new RestartableOffheapStore(new BackingMapFactory<EhcacheConcurrentOffHeapClockCache, OffHeapStore>(){

            @Override
            public EhcacheConcurrentOffHeapClockCache create(OffHeapStore store, OffHeapPoolParticipant participant) {
                Configuration config = cache.getCacheManager().getConfiguration();
                CacheConfiguration cacheConfig = cache.getCacheConfiguration();
                OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.EvictionOutcome.class).of(store)).named("eviction")).build();
                if (offHeapPool != null) {
                    return OffHeapStoreFactory.createRestartablePooledBackingMap(restartability, offHeapPool, store, participant, cache.getCacheEventNotificationService(), evictionObserver, config, cacheConfig, synchronousWrites, searchManager);
                }
                return OffHeapStoreFactory.createRestartableBackingMap(restartability, store, cache.getCacheEventNotificationService(), evictionObserver, new HeuristicConfiguration(cache.getName(), cacheConfig.getMaxBytesLocalOffHeap()), config, cacheConfig, synchronousWrites, searchManager);
            }
        }, cache, offHeapPool, searchManager, synchronousWrites, restartability);
    }

    public static EhcacheConcurrentOffHeapClockCache createBackingMap(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, OffHeapConfiguration config, CacheConfiguration cacheConfig, LuceneIndexedSearchManager searchManager) {
        LOGGER.info("Creating Off-Heap Area Using Config\n {}", (Object)config);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreFactory.getBufferSource(cacheConfig.getName()), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        EhcacheKeyPortability keyPortability = new EhcacheKeyPortability();
        EhcacheElementPortability elementPortability = new EhcacheElementPortability(cacheConfig);
        Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, source, config.getSegmentDataPageSize(), keyPortability, elementPortability, false, true);
        if (searchManager != null) {
            storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
        }
        EhcacheSegmentFactory segmentFactory = new EhcacheSegmentFactory(evictionListener, evictionObserver, source, storageEngineFactory, config.getInitialSegmentTableSize(), OffHeapStoreFactory.determineCachePinned(cacheConfig));
        return new EhcacheConcurrentOffHeapClockCache(segmentFactory, config.getConcurrency());
    }

    public static EhcacheConcurrentOffHeapClockCache createPooledBackingMap(OffHeapPool pool, OffHeapPoolParticipant owner, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, CacheConfiguration cacheConfig, LuceneIndexedSearchManager searchManager) {
        OffHeapConfiguration config = pool.getPoolConfiguration();
        EhcacheKeyPortability keyPortability = new EhcacheKeyPortability();
        EhcacheElementPortability elementPortability = new EhcacheElementPortability(cacheConfig);
        Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, pool.getPageSource(), config.getSegmentDataPageSize(), keyPortability, elementPortability, false, true);
        if (searchManager != null) {
            storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
        }
        EhcachePooledSegmentFactory segmentFactory = new EhcachePooledSegmentFactory(pool, owner, evictionListener, evictionObserver, pool.getPageSource(), storageEngineFactory, config.getInitialSegmentTableSize(), OffHeapStoreFactory.determineCachePinned(cacheConfig));
        return new EhcacheConcurrentOffHeapClockCache(segmentFactory, config.getConcurrency());
    }

    public static EhcacheConcurrentOffHeapClockCache createRestartableBackingMap(EhcacheRestartability restartability, OffHeapStore owner, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, OffHeapConfiguration offHeapConfig, Configuration config, CacheConfiguration cacheConfig, boolean synchronousWrites, LuceneIndexedSearchManager searchManager) {
        ByteBuffer identifier = EhcacheRestartability.getCacheIdentifier(cacheConfig.getName());
        LOGGER.info("Creating Off-Heap Area Using Config\n {}", (Object)offHeapConfig);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreFactory.getBufferSource(cacheConfig.getName()), offHeapConfig.getMaximumSize(), offHeapConfig.getMaximumChunkSize(), offHeapConfig.getMinimumChunkSize());
        SerializablePortability restartablePortability = restartability.getRestartablePortability();
        EhcacheKeyPortability keyPortability = new EhcacheKeyPortability(restartablePortability);
        EhcacheElementPortability elementPortability = new EhcacheElementPortability(restartablePortability, cacheConfig);
        Factory<OffHeapBufferStorageEngine<Serializable, Element>> delegateFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, source, offHeapConfig.getSegmentDataPageSize(), keyPortability, new LinkedNodePortability<Element>(elementPortability), false, true);
        Factory storageEngineFactory = RestartableStorageEngine.createFactory(identifier, restartability.getCacheStore(), delegateFactory, synchronousWrites);
        if (searchManager != null) {
            storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
        }
        EhcacheSegmentFactory segmentFactory = new EhcacheSegmentFactory(evictionListener, evictionObserver, source, storageEngineFactory, offHeapConfig.getInitialSegmentTableSize(), OffHeapStoreFactory.determineCachePinned(cacheConfig));
        EhcacheConcurrentOffHeapClockCache cache = new EhcacheConcurrentOffHeapClockCache(segmentFactory, offHeapConfig.getConcurrency());
        restartability.registerCacheStripe(config, cacheConfig, new EhcacheOffHeapObjectManagerStripe(identifier, owner, cache));
        return cache;
    }

    public static EhcacheConcurrentOffHeapClockCache createRestartablePooledBackingMap(EhcacheRestartability restartability, OffHeapPool pool, OffHeapStore owner, OffHeapPoolParticipant participant, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, Configuration config, CacheConfiguration cacheConfig, boolean synchronousWrites, LuceneIndexedSearchManager searchManager) {
        ByteBuffer identifier = EhcacheRestartability.getCacheIdentifier(cacheConfig.getName());
        ByteBuffer pinnedIdentifier = EhcacheRestartability.getCachePinningIdentifier(cacheConfig.getName());
        OffHeapConfiguration offHeapConfig = pool.getPoolConfiguration();
        SerializablePortability restartablePortability = restartability.getRestartablePortability();
        EhcacheKeyPortability keyPortability = new EhcacheKeyPortability(restartablePortability);
        EhcacheElementPortability elementPortability = new EhcacheElementPortability(restartablePortability, cacheConfig);
        Factory<OffHeapBufferStorageEngine<Serializable, Element>> delegateFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, pool.getPageSource(), offHeapConfig.getSegmentDataPageSize(), keyPortability, new LinkedNodePortability<Element>(elementPortability), false, true);
        Factory storageEngineFactory = RestartableStorageEngine.createFactory(identifier, restartability.getCacheStore(), delegateFactory, synchronousWrites);
        if (searchManager != null) {
            storageEngineFactory = searchManager.newSearchStorageEngineListeningFactory(storageEngineFactory, keyPortability, cacheConfig);
        }
        EhcachePooledSegmentFactory segmentFactory = new EhcachePooledSegmentFactory(pool, participant, evictionListener, evictionObserver, pool.getPageSource(), storageEngineFactory, offHeapConfig.getInitialSegmentTableSize(), OffHeapStoreFactory.determineCachePinned(cacheConfig));
        EhcacheConcurrentOffHeapClockCache cache = new EhcacheConcurrentOffHeapClockCache(segmentFactory, offHeapConfig.getConcurrency());
        restartability.registerCacheStripe(config, cacheConfig, new EhcacheOffHeapObjectManagerStripe(identifier, owner, cache));
        return cache;
    }

    public static BufferSource getBufferSource(String cacheName) {
        long slowDelay = AdvancedConfigPropertyParser.getAdvancedLongConfigProperty(SLOW_DELAY_PROPERTY, cacheName, 3000L);
        long critDelay = AdvancedConfigPropertyParser.getAdvancedLongConfigProperty(CRITICAL_DELAY_PROPERTY, cacheName, 30000L);
        boolean haltOnCrit = AdvancedConfigPropertyParser.getAdvancedBooleanConfigProperty(HALT_ON_CRITICAL_DELAY_PROPERTY, cacheName, true);
        return new TimingBufferSource(new OffHeapBufferSource(), slowDelay, TimeUnit.MILLISECONDS, critDelay, TimeUnit.MILLISECONDS, haltOnCrit);
    }

    public static BufferSource getBufferSource() {
        long slowDelay = AdvancedConfigPropertyParser.getAdvancedLongConfigProperty(SLOW_DELAY_PROPERTY, 3000L);
        long critDelay = AdvancedConfigPropertyParser.getAdvancedLongConfigProperty(CRITICAL_DELAY_PROPERTY, 30000L);
        boolean haltOnCrit = AdvancedConfigPropertyParser.getAdvancedBooleanConfigProperty(HALT_ON_CRITICAL_DELAY_PROPERTY, true);
        return new TimingBufferSource(new OffHeapBufferSource(), slowDelay, TimeUnit.MILLISECONDS, critDelay, TimeUnit.MILLISECONDS, haltOnCrit);
    }

    protected static boolean determineCachePinned(CacheConfiguration cacheConfiguration) {
        PinningConfiguration pinningConfiguration = cacheConfiguration.getPinningConfiguration();
        if (pinningConfiguration == null) {
            return false;
        }
        switch (pinningConfiguration.getStore()) {
            case LOCALMEMORY: {
                return false;
            }
            case INCACHE: {
                return !cacheConfiguration.isOverflowToDisk();
            }
        }
        throw new IllegalArgumentException();
    }
}

