/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;

public class LSNGapCompactionPolicy
implements CompactionPolicy {
    private final ObjectManager<?, ?, ?> objectManager;
    private final LogManager logManager;
    private final double minLoad;
    private final double maxLoad;
    private final int windowSize;
    private long compactedCount;
    private long liveSize;
    private long currentLsn;
    private int windowCount;
    private boolean isCompacting = false;

    public LSNGapCompactionPolicy(ObjectManager<?, ?, ?> objectManager, LogManager logManager, Configuration configuration) {
        this.objectManager = objectManager;
        this.logManager = logManager;
        this.minLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MIN_LOAD);
        this.maxLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MAX_LOAD);
        this.windowSize = configuration.getInt(FrsProperty.COMPACTOR_LSNGAP_WINDOW_SIZE);
    }

    protected float calculateRatio(long liveEntries, long totalEntries) {
        return (float)liveEntries / (float)totalEntries;
    }

    @Override
    public boolean startCompacting() {
        if (this.isCompacting) {
            throw new IllegalStateException("Compaction is already started.");
        }
        this.liveSize = this.objectManager.size();
        this.currentLsn = this.logManager.currentLsn();
        long lowestLsn = this.objectManager.getLowestLsn();
        float ratio = this.calculateRatio(this.liveSize, this.currentLsn - lowestLsn);
        if ((double)ratio <= this.minLoad) {
            this.compactedCount = 0L;
            this.windowCount = 0;
            this.isCompacting = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        if (!this.isCompacting) {
            throw new IllegalStateException("Compaction is not running.");
        }
        ++this.compactedCount;
        if (this.compactedCount >= this.liveSize) {
            return false;
        }
        double estimatedRatio = this.estimateRatio(entry.getLsn());
        if (estimatedRatio <= this.maxLoad || estimatedRatio > 1.0) {
            this.windowCount = 0;
            return true;
        }
        if (++this.windowCount >= this.windowSize) {
            long officialLowestLsn = this.objectManager.getLowestLsn();
            this.logManager.updateLowestLsn(officialLowestLsn);
            estimatedRatio = this.estimateRatio(officialLowestLsn);
            if (estimatedRatio <= this.maxLoad) {
                this.windowCount = 0;
                return true;
            }
            return false;
        }
        return true;
    }

    private double estimateRatio(long minLsn) {
        return (double)this.liveSize / (double)(this.compactedCount + this.currentLsn - minLsn);
    }

    @Override
    public void stoppedCompacting() {
        if (!this.isCompacting) {
            throw new IllegalStateException("Compaction is not running.");
        }
        this.isCompacting = false;
    }
}

