/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.pwall.json.JSONException;
import net.pwall.json.JSONNumberValue;
import net.pwall.util.Strings;

public class JSONDecimal
extends JSONNumberValue {
    private static final long serialVersionUID = 5004532203973159380L;
    public static final JSONDecimal ZERO = new JSONDecimal(BigDecimal.ZERO);
    private final BigDecimal bigDecimal;
    private final String string;

    public JSONDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
        this.string = bigDecimal.toString();
    }

    public JSONDecimal(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Must not be null or empty");
        }
        try {
            this.bigDecimal = new BigDecimal(string);
        }
        catch (Exception e) {
            throw new JSONException("Illegal JSON number");
        }
        this.string = string;
    }

    public BigDecimal getValue() {
        return this.bigDecimal;
    }

    @Override
    public BigDecimal toSimpleValue() {
        return this.bigDecimal;
    }

    @Override
    public int intValue() {
        return this.bigDecimal.intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal.longValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal.doubleValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimal.toBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.bigDecimal;
    }

    @Override
    public String toJSON() {
        return this.string;
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append(this.toJSON());
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return this.bigDecimal.intValue();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONNumberValue && ((JSONNumberValue)other).valueEquals(this.bigDecimal);
    }

    @Override
    public boolean valueEquals(int other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(long other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(float other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(double other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(BigInteger other) {
        return new BigDecimal(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(BigDecimal other) {
        return other.compareTo(this.bigDecimal) == 0;
    }

    public static JSONDecimal valueOf(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? ZERO : new JSONDecimal(bigDecimal);
    }

    public static JSONDecimal valueOf(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Must not be null or empty");
        }
        if (s.indexOf(46) >= 0) {
            return s.charAt(0) == '0' && s.charAt(s.length() - 1) == '0' && Strings.trim((String)s, ch -> ch == 48).equals(".") ? ZERO : new JSONDecimal(s);
        }
        return Strings.trim((String)s, ch -> ch == 48).length() == 0 ? ZERO : new JSONDecimal(s);
    }

    public static JSONDecimal valueOf(double d) {
        return d == 0.0 ? ZERO : new JSONDecimal(BigDecimal.valueOf(d));
    }

    public static JSONDecimal valueOf(long i) {
        return i == 0L ? ZERO : new JSONDecimal(BigDecimal.valueOf(i));
    }
}

