/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.json.JSON;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.Parser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004J\f\u0010\u0014\u001a\u00020\r*\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/pwall/json/schema/parser/JSONReader;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "jsonCache", "", "Lnet/pwall/json/JSONValue;", "getUriResolver", "()Lkotlin/jvm/functions/Function1;", "preLoad", "", "file", "Ljava/io/File;", "filename", "", "readJSON", "uri", "cacheByURI", "json-kotlin-schema"})
public final class JSONReader {
    private final Map<URI, JSONValue> jsonCache;
    @NotNull
    private final Function1<URI, InputStream> uriResolver;

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.preLoad(new File(filename));
    }

    public final void preLoad(@NotNull File file) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory()) break block3;
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block4;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    File file2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
                    String string = file2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (StringsKt.startsWith$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) continue;
                    this.preLoad(it);
                }
                break block4;
            }
            if (!file.isFile()) break block4;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (StringsKt.endsWith((String)string, (String)".json", (boolean)true)) {
                JSONValue jSONValue = JSON.parse((File)file);
                if (jSONValue != null) {
                    JSONValue jSONValue2 = jSONValue;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONValue it = jSONValue2;
                    boolean bl3 = false;
                    URI uRI = file.toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"file.toURI()");
                    this.jsonCache.put(uRI, it);
                    this.cacheByURI(it);
                }
            }
        }
    }

    @NotNull
    public final JSONValue readJSON(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URI uri = file.toURI();
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue != null) {
            JSONValue jSONValue2 = jSONValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            return it;
        }
        try {
            File file2 = file;
            boolean bl = false;
            JSONValue jSONValue3 = JSON.parse((InputStream)new FileInputStream(file2));
            if (jSONValue3 == null) {
                throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + file));
            }
            JSONValue json = jSONValue3;
            URI uRI = uri;
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
            this.jsonCache.put(uRI, json);
            this.cacheByURI(json);
            return json;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new JSONSchemaException("Error reading schema file - " + file, e));
        }
    }

    @NotNull
    public final JSONValue readJSON(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue != null) {
            JSONValue jSONValue2 = jSONValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            return it;
        }
        try {
            InputStream inputStream = (InputStream)this.uriResolver.invoke((Object)uri);
            if (inputStream == null) {
                throw (Throwable)((Object)new JSONSchemaException("Can't resolve name - " + uri));
            }
            JSONValue jSONValue3 = JSON.parse((InputStream)inputStream);
            if (jSONValue3 == null) {
                throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + uri));
            }
            JSONValue json = jSONValue3;
            this.jsonCache.put(uri, json);
            this.cacheByURI(json);
            return json;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new JSONSchemaException("Error reading schema file - " + uri, e));
        }
    }

    private final void cacheByURI(JSONValue $this$cacheByURI) {
        block1: {
            if (!($this$cacheByURI instanceof JSONObject)) break block1;
            String string = Parser.Companion.getStringOrNull((JSONObject)$this$cacheByURI, JSONPointer.Companion.getRoot().child("$id"));
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.jsonCache.put(Parser.Companion.dropFragment(new URI(it)), $this$cacheByURI);
            }
        }
    }

    @NotNull
    public final Function1<URI, InputStream> getUriResolver() {
        return this.uriResolver;
    }

    public JSONReader(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.uriResolver = uriResolver;
        boolean bl = false;
        this.jsonCache = new LinkedHashMap();
    }
}

