/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.subschema;

import io.kjson.JSONArray;
import io.kjson.JSONValue;
import io.kjson.pointer.IndexOpKt;
import io.kjson.pointer.JSONPointer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicOutput;
import net.pwall.json.schema.output.DetailedOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0013\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/subschema/ItemsArraySchema;", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "uri", "Ljava/net/URI;", "location", "Lio/kjson/pointer/JSONPointer;", "itemSchemaList", "", "Lnet/pwall/json/schema/JSONSchema;", "<init>", "(Ljava/net/URI;Lio/kjson/pointer/JSONPointer;Ljava/util/List;)V", "getItemSchemaList", "()Ljava/util/List;", "childLocation", "pointer", "validate", "", "json", "Lio/kjson/JSONValue;", "instanceLocation", "validateBasic", "Lnet/pwall/json/schema/output/BasicOutput;", "relativeLocation", "validateDetailed", "Lnet/pwall/json/schema/output/DetailedOutput;", "equals", "other", "", "hashCode", "", "json-kotlin-schema"})
public final class ItemsArraySchema
extends JSONSchema.SubSchema {
    @NotNull
    private final List<JSONSchema> itemSchemaList;

    public ItemsArraySchema(@Nullable URI uri, @NotNull JSONPointer location, @NotNull List<? extends JSONSchema> itemSchemaList) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(itemSchemaList, (String)"itemSchemaList");
        super(uri, location);
        this.itemSchemaList = itemSchemaList;
    }

    @NotNull
    public final List<JSONSchema> getItemSchemaList() {
        return this.itemSchemaList;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        return pointer.child("items");
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        if (!(instance instanceof JSONArray)) {
            return true;
        }
        int n = Math.min(((JSONArray)instance).size(), this.itemSchemaList.size());
        for (int i = 0; i < n; ++i) {
            if (this.itemSchemaList.get(i).validate(json, instanceLocation.child(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public BasicOutput validateBasic(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        if (!(instance instanceof JSONArray)) {
            return BasicOutput.Companion.getTrueOutput();
        }
        List errors = new ArrayList();
        int n = Math.min(((JSONArray)instance).size(), this.itemSchemaList.size());
        for (int i = 0; i < n; ++i) {
            BasicOutput it = this.itemSchemaList.get(i).validateBasic(relativeLocation.child(i), json, instanceLocation.child(i));
            boolean bl = false;
            if (it.getValid()) continue;
            JSONSchema.Companion.addAllFromNullable(errors, (Collection)it.getErrors());
        }
        if (errors.isEmpty()) {
            return BasicOutput.Companion.getTrueOutput();
        }
        return new BasicOutput(false, errors);
    }

    @Override
    @NotNull
    public DetailedOutput validateDetailed(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        DetailedOutput detailedOutput;
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        if (!(instance instanceof JSONArray)) {
            return JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "Value is not an array", null, null, 24, null);
        }
        List errors = new ArrayList();
        int n = Math.min(((JSONArray)instance).size(), this.itemSchemaList.size());
        for (int i = 0; i < n; ++i) {
            DetailedOutput it = this.itemSchemaList.get(i).validateDetailed(relativeLocation.child(i), json, instanceLocation.child(i));
            boolean bl = false;
            if (it.getValid()) continue;
            errors.add(it);
        }
        switch (errors.size()) {
            case 0: {
                detailedOutput = JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "All items are valid", null, null, 24, null);
                break;
            }
            case 1: {
                detailedOutput = (DetailedOutput)errors.get(0);
                break;
            }
            default: {
                detailedOutput = JSONSchema.createError$default(this, relativeLocation, instanceLocation, "Errors in array items", errors, null, 16, null);
            }
        }
        return detailedOutput;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ItemsArraySchema && super.equals(other) && Intrinsics.areEqual(this.itemSchemaList, ((ItemsArraySchema)other).itemSchemaList);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.itemSchemaList).hashCode();
    }
}

